#!/bin/tcsh
#BSUB -W 4200
#BSUB -n 4
#BSUB -q gpu
#BSUB -R "select[a10]"
#BSUB -gpu "num=2:mode=shared:mps=no"
#BSUB -J cs-s2
#BSUB -o /gpfs_common/share03/hdai/mreza2/transferable_attack/baselline/Proposed/BAT/Logfiles/%J.out
#BSUB -e /gpfs_common/share03/hdai/mreza2/transferable_attack/baselline/Proposed/BAT/Logfiles/%J.err
#module load conda
#module load cuda
conda activate /usr/local/usrapps/hdai/mreza2/myenv
setenv CUDA_VISIBLE_DEVICES 0,1
set match_targets = (60 344)         #S1: 23 54 S2: 60 344 S3: 443 600 S4: 769 885
set gamma = 0.5
# set src_domain = "natural_image"
# set TarSmplTyp = "crafted_from_noise"
set TarSamNum = 300   #  100 300 500 700 1000 1250
set attack_type = "BAT_CS"    # 'BAT_BS, BAT_CS, BAT_CN'
set surr_name = "3RN2DN"
set K = 5    # Number of discriminators
 
foreach match_target ($match_targets)
    echo "Running with a match target $match_target"
    torchrun --nproc_per_node=2 train.py \
        --attack_type $attack_type \
        --gamma $gamma --K $K \
        --TarSamNum $TarSamNum \
        --epochs 20 --match_target $match_target --batch_size 8 \
        --surr_name $surr_name > ./checkpoint/multiDiscri_{$surr_name}_K{$K}_target_${match_target}_{$TarSamNum}.txt
end
conda deactivate  