#!/usr/bin/env python
# coding: utf-8

# In[1]:


from gridworld_reward import gridworld
from automaton import DFA
from pomdp import constrained_pomdp
from combine_reward import combine
import pickle
from copy import deepcopy
import numpy as np


# In[2]:


A = DFA('F(a) & G(!d)','/Users/krishnachaitanyakalagarla/anaconda3/envs/multipomdp/lib/python3.7/site-packages')


# In[3]:


m = 4
n = 4
p = 0.95


# In[4]:


horizon = 10
thres = 0.5


# In[5]:


rew = np.zeros(m*n,dtype=float)


# In[6]:


rew[3] = 2.0 
rew[15] = 1.0


# In[7]:


pomdp = gridworld(m,n,horizon,p,rew)
label_v = [()]*(m*n)


# In[8]:


label_v[15] = ('a',)
label_v[6] = ('d',)


# In[9]:


labels = {t:deepcopy(label_v) for t in range(1,horizon+1)}


# In[10]:


prod = combine(A,pomdp,labels,thres)


# In[11]:


pickle.dump(prod,open("case1.1","wb"))

