# Rolling

## Dependencies

Install [opto](https://github.com/robertocalandra/opto) for Bayesian Optimization
```
# install a FORTRAN compiler for opto
sudo apt-get install gfortran

# install opto
git clone https://github.com/robertocalandra/opto.git
cd opto
pip install -r requirements.txt
python setup.py install
```

Install [scipyplot](https://github.com/robertocalandra/scipyplot), [deepdish](https://github.com/uchicago-cs/deepdish).
```
pip install scipyplot deepdish
```

## Content

1) RollingEnv.py: pybullet envrionment for rolling ball between two sensor with tactile output
2) Rolling.py: wrapper class for opto Bayesian optimization
3) BO_rolling_collect.py: Bayesian optimization and random sampling to learn the control parameters for 30 times
4) draw_rolling.py: plot learning curve based on logs generated by BO_rolling_collect.py

## Usage

Run BO and random sampling experiments. The logs will be saved in logs folder. (Optional: disable visualization for faster speed).
```
python BO_rolling_collect.py
```

Plot learning curve based on logs.
```
python draw_rolling.py
```