import os
import imageio
from PIL import Image
from evaluation.utils import get_subtasks

def generate_gif(data_path, save_name, save_dir):
    image_list = os.listdir(data_path)
    image_list = sorted([os.path.join(data_path,im) for im in image_list if 'step' in im])

    paths = [Image.open(i) for i in image_list]
    imageio.mimsave(save_dir+'/{}.gif'.format(save_name), paths, fps=30.0)



gif_dir = "./gif/"
if not os.path.exists(gif_dir): os.makedirs(gif_dir)

tasks = get_subtasks() #["open_drawer"]
episode_idxs = [3] #list(range(1,11)) #[1, 2, 3]

total_step, step = len(tasks)*len(episode_idxs), 0
num_bars = 50

for task in tasks:
    for idx in episode_idxs:
        #data_path = os.path.join("./record",task,"episode{:03d}".format(idx))
        data_path = os.path.join("./record","episode{:03d}".format(idx))
        if not os.path.exists(data_path):
            print("  * [ERROR] There is no path:", data_path)

        else:
            save_path = os.path.join(gif_dir, task)
            if not os.path.exists(save_path): os.makedirs(save_path)

            generate_gif(data_path, "episode{:03d}".format(idx), save_path)

        step += 1
        progress_ = int(step/total_step*num_bars)
        percent_ = step/total_step*100
        print('[GIF-GENERATION][Progress {}{}:{:.1f}%]         '\
            .format('█'*progress_, ' '*(num_bars-progress_), percent_), end='\r')

print('[GIF-GENERATION][Progress {}:100.0%]         '.format('█'*num_bars))

