# Running Experiments with Baselines

To run experiments with baselines, install the required packages from `requirements.txt` or set up a Conda environment.

## Baselines

The baselines are located in the `mikasa/baselines` directory.

### Example Training Command

To start training using PPO-LSTM, execute the following command:

```bash
python3 ../baselines/ppo_lstm.py \
    --num_envs 128 --env_id 'AutoencodeHard-v0' --num_steps 311 --num_eval_steps 311 \
    --total_timesteps 10_000_000_000 --seed 1 --learning_rate 2.5e-4 \
    --gamma 0.99 --gae_lambda 0.95 --num_minibatches 4 --update_epochs 4 \
    --norm_adv --anneal_lr --clip_vloss --clip_coef 0.1 --ent_coef 0.01 --vf_coef 0.5 \
    --max_grad_norm 0.5 --target_kl None
```

Make sure you have all dependencies installed before running the script.

