#!/bin/bash

for seed in 123 231 321
do
    echo "Running experiment with seed $seed"
    python3 baselines/ppo/ppo_memtasks.py \
        --env_id=SeqOfColors3-v0 \
        --exp-name=ppo-mlp-rgb-joint-dense-seq-of-colors-3-v0 \
        --capture-video \
        --save-model \
        --track \
        --num-steps=120 \
        --num_eval_steps=360 \
        --include-rgb \
        --include-joints \
        --seed=$seed \
        --total-timesteps=50_000_000 \
        --no-finite-horizon-gae \
        --eval-freq=50 \
        --num-envs=256 \
        --gamma=0.9 \
        --num-minibatches=32 \
        --update-epochs=8 \
        
done