/*
 * Decompiled with CFR 0.152.
 */
package org.openslide;

import java.awt.image.BufferedImage;
import java.io.IOException;
import org.openslide.OpenSlide;

public class AssociatedImage {
    private final String name;
    private final OpenSlide os;

    AssociatedImage(String name, OpenSlide os) {
        if (name == null || os == null) {
            throw new NullPointerException("Arguments cannot be null");
        }
        this.name = name;
        this.os = os;
    }

    public String getName() {
        return this.name;
    }

    public OpenSlide getOpenSlide() {
        return this.os;
    }

    public BufferedImage toBufferedImage() throws IOException {
        return this.os.getAssociatedImage(this.name);
    }

    public int hashCode() {
        return this.os.hashCode() + this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AssociatedImage) {
            AssociatedImage ai2 = (AssociatedImage)obj;
            return this.os.equals(ai2.os) && this.name.equals(ai2.name);
        }
        return false;
    }
}

