/*
 * Decompiled with CFR 0.152.
 */
package org.openslide;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

class OpenSlideJNI {
    private OpenSlideJNI() {
    }

    static native String openslide_detect_vendor(String var0);

    static native long openslide_open(String var0);

    static native int openslide_get_level_count(long var0);

    static native void openslide_get_level_dimensions(long var0, int var2, long[] var3);

    static native double openslide_get_level_downsample(long var0, int var2);

    static native void openslide_close(long var0);

    static native String[] openslide_get_property_names(long var0);

    static native String openslide_get_property_value(long var0, String var2);

    static native String[] openslide_get_associated_image_names(long var0);

    static native void openslide_read_region(long var0, int[] var2, long var3, long var5, int var7, long var8, long var10);

    static native void openslide_get_associated_image_dimensions(long var0, String var2, long[] var3);

    static native void openslide_read_associated_image(long var0, String var2, int[] var3);

    static native String openslide_get_error(long var0);

    static native String openslide_get_version();

    static {
        String libraryPath = null;
        try {
            InputStream is = OpenSlideJNI.class.getClassLoader().getResourceAsStream("resources/openslide.properties");
            if (is != null) {
                Properties p = new Properties();
                p.load(is);
                libraryPath = p.getProperty("openslide.jni.path");
                if (libraryPath.equals("")) {
                    libraryPath = null;
                }
            }
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        if (libraryPath != null) {
            System.load(libraryPath);
        } else {
            System.loadLibrary("openslide-jni");
        }
    }
}

