/*
 * Decompiled with CFR 0.152.
 */
package org.openslide;

import java.io.File;
import java.io.IOException;
import org.openslide.OpenSlide;

public class TestCLI {
    static void print_downsamples(OpenSlide osr) {
        for (int level = 0; level < osr.getLevelCount(); ++level) {
            System.out.printf("level %d: downsample: %g\n", level, osr.getLevelDownsample(level));
        }
    }

    static void test_next_biggest(OpenSlide osr, double downsample) {
        int level = osr.getBestLevelForDownsample(downsample);
        System.out.printf("level for downsample %g: %d (%g)\n", downsample, level, osr.getLevelDownsample(level));
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.printf("give file!\n", new Object[0]);
            return;
        }
        System.out.printf("version: %s\n", OpenSlide.getLibraryVersion());
        File f = new File(args[0]);
        System.out.printf("openslide_detect_vendor returns %s\n", OpenSlide.detectVendor(f));
        OpenSlide osr = new OpenSlide(f);
        osr.dispose();
        osr = new OpenSlide(f);
        long w = osr.getLevel0Width();
        long h = osr.getLevel0Height();
        System.out.printf("dimensions: %d x %d\n", w, h);
        int levels = osr.getLevelCount();
        System.out.printf("num levels: %d\n", levels);
        TestCLI.print_downsamples(osr);
        TestCLI.test_next_biggest(osr, 0.8);
        TestCLI.test_next_biggest(osr, 1.0);
        TestCLI.test_next_biggest(osr, 1.5);
        TestCLI.test_next_biggest(osr, 2.0);
        TestCLI.test_next_biggest(osr, 3.0);
        TestCLI.test_next_biggest(osr, 3.1);
        TestCLI.test_next_biggest(osr, 10.0);
        TestCLI.test_next_biggest(osr, 20.0);
        TestCLI.test_next_biggest(osr, 25.0);
        TestCLI.test_next_biggest(osr, 100.0);
        TestCLI.test_next_biggest(osr, 1000.0);
        TestCLI.test_next_biggest(osr, 10000.0);
        osr.dispose();
    }
}

