/*
 * Decompiled with CFR 0.152.
 */
package org.openslide.gui;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.openslide.AssociatedImage;
import org.openslide.OpenSlide;
import org.openslide.gui.OpenSlideView;

public class Demo {
    public static void main(final String[] args) {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "OpenSlide Demo");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame jf = new JFrame("OpenSlide");
                jf.setDefaultCloseOperation(3);
                try {
                    switch (args.length) {
                        case 0: {
                            JFileChooser jfc = new JFileChooser();
                            jfc.setAcceptAllFileFilterUsed(false);
                            jfc.setFileFilter(OpenSlide.getFileFilter());
                            int result = jfc.showDialog(null, "Open");
                            if (result == 0) {
                                this.openOne(jfc.getSelectedFile(), jf);
                                break;
                            }
                            return;
                        }
                        case 1: {
                            this.openOne(new File(args[0]), jf);
                            break;
                        }
                        case 2: {
                            final OpenSlideView w1 = new OpenSlideView(new OpenSlide(new File(args[0])), true);
                            final OpenSlideView w2 = new OpenSlideView(new OpenSlide(new File(args[1])), true);
                            Box b = Box.createHorizontalBox();
                            b.add(w1);
                            b.add(w2);
                            jf.getContentPane().add(b);
                            JToggleButton linker = new JToggleButton("Link");
                            jf.getContentPane().add((Component)linker, "South");
                            linker.addItemListener(new ItemListener(){

                                @Override
                                public void itemStateChanged(ItemEvent e) {
                                    switch (e.getStateChange()) {
                                        case 1: {
                                            w1.linkWithOther(w2);
                                            break;
                                        }
                                        case 2: {
                                            w1.unlinkOther();
                                        }
                                    }
                                }
                            });
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    System.exit(1);
                }
                jf.setSize(900, 700);
                jf.setVisible(true);
            }

            private void openOne(File file, JFrame jf) throws IOException {
                OpenSlide os = new OpenSlide(file);
                final OpenSlideView wv = new OpenSlideView(os, true);
                wv.setBorder(BorderFactory.createTitledBorder(file.getName()));
                jf.getContentPane().add(wv);
                final JLabel l = new JLabel(" ");
                jf.getContentPane().add((Component)l, "South");
                wv.addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        long x = wv.getSlideX(e.getX());
                        long y = wv.getSlideY(e.getY());
                        l.setText("(" + x + "," + y + ")");
                    }
                });
                wv.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseExited(MouseEvent e) {
                        l.setText(" ");
                    }
                });
                for (AssociatedImage img : os.getAssociatedImages().values()) {
                    JFrame j = new JFrame(img.getName());
                    j.setDefaultCloseOperation(2);
                    j.add(new JLabel(new ImageIcon(img.toBufferedImage())));
                    j.pack();
                    j.setVisible(true);
                }
                Map<String, String> properties = os.getProperties();
                ArrayList<Object[]> propList = new ArrayList<Object[]>();
                TreeSet<Map.Entry<String, String>> sorted = new TreeSet<Map.Entry<String, String>>(new Comparator<Map.Entry<String, String>>(){

                    @Override
                    public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                        String k1 = o1.getKey();
                        String k2 = o2.getKey();
                        return k1.compareTo(k2);
                    }
                });
                sorted.addAll(properties.entrySet());
                for (Map.Entry entry : sorted) {
                    propList.add(new Object[]{entry.getKey(), entry.getValue()});
                }
                JTable propTable = new JTable((Object[][])propList.toArray((T[])new Object[1][0]), new String[]{"key", "value"}){

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                JFrame jFrame = new JFrame("properties");
                jFrame.add(new JScrollPane(propTable));
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
    }
}

