/*
 * Decompiled with CFR 0.152.
 */
package org.openslide.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openslide.OpenSlide;
import org.openslide.gui.Annotation;
import org.openslide.gui.DefaultAnnotation;
import org.openslide.gui.DefaultSelectionListModel;
import org.openslide.gui.SelectionListModel;

public class OpenSlideView
extends JPanel {
    private static final int KEYBOARD_SCROLL_AMOUNT = 100;
    private boolean selectionsAsPins;
    private final double downsampleBase;
    private final int maxDownsampleExponent;
    private final transient OpenSlide osr;
    private int rotation;
    private int downsampleExponent;
    private boolean firstPaint = true;
    private Point viewPosition = new Point();
    private OpenSlideView otherView;
    private SelectionListModel selections = new DefaultSelectionListModel();
    private Shape selectionBeingDrawn;
    private transient BufferedImage dbuf;
    private double tmpZoomScale = 1.0;
    private int tmpZoomX;
    private int tmpZoomY;
    private final boolean startWithZoomFit;
    private boolean selectionsVisible;

    public OpenSlideView(OpenSlide w) {
        this(w, false);
    }

    public OpenSlideView(OpenSlide w, boolean startWithZoomFit) {
        this(w, 1.2, 40, startWithZoomFit);
    }

    public OpenSlideView(OpenSlide w, double downsampleBase, int maxDownsampleExponent, boolean startWithZoomFit) {
        if (w.getLevel0Width() > Integer.MAX_VALUE || w.getLevel0Height() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("OpenSlide size must not exceed (2147483647,2147483647)");
        }
        this.osr = w;
        this.downsampleBase = downsampleBase;
        this.maxDownsampleExponent = maxDownsampleExponent;
        this.startWithZoomFit = startWithZoomFit;
        this.setFocusable(true);
        this.setOpaque(true);
        this.registerEventHandlers();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.dbuf != null) {
            this.paintBackingStore();
            this.repaint();
        }
    }

    private static void translateHelper(OpenSlideView ws, int dX, int dY) {
        if (ws == null) {
            return;
        }
        ws.translateSlidePrivate(dX, dY);
    }

    private static void repaintHelper(OpenSlideView w) {
        if (w == null) {
            return;
        }
        w.repaint();
    }

    private static void selectionsVisibleHelper(OpenSlideView w, boolean visible) {
        if (w == null) {
            return;
        }
        w.selectionsVisible = visible;
        w.repaint();
    }

    private static void centerHelper(OpenSlideView w) {
        if (w == null) {
            return;
        }
        w.centerSlidePrivate();
    }

    private void translateSlidePrivate(int dX, int dY) {
        int w = this.dbuf.getWidth();
        int h = this.dbuf.getHeight();
        Graphics2D g = this.dbuf.createGraphics();
        if (Math.abs(dX) >= w || Math.abs(dY) >= h) {
            this.viewPosition.translate(dX, dY);
            g.setClip(0, 0, w, h);
            this.paintBackingStore(g);
            g.dispose();
            return;
        }
        g.copyArea(0, 0, w, h, -dX, -dY);
        this.viewPosition.translate(dX, dY);
        if (dY > 0) {
            g.setClip(0, h - dY, w, dY);
            this.paintBackingStore(g);
            h -= dY;
            dY = 0;
        } else if (dY < 0) {
            g.setClip(0, 0, w, -dY);
            this.paintBackingStore(g);
            h += dY;
            dY = -dY;
        }
        if (dX > 0) {
            g.setClip(w - dX, dY, dX, h);
            this.paintBackingStore(g);
        } else if (dX < 0) {
            g.setClip(0, dY, -dX, h);
            this.paintBackingStore(g);
        }
        g.dispose();
    }

    private static double zoomHelper(OpenSlideView w, int x, int y, int amount) {
        if (w == null) {
            return 1.0;
        }
        double oldDS = w.getDownsample();
        w.zoomSlide(x, y, amount);
        double newDS = w.getDownsample();
        return oldDS / newDS;
    }

    private static void zoomHelper2(OpenSlideView w, double relDS, int x, int y) {
        if (w == null) {
            return;
        }
        if (relDS != 1.0) {
            w.tmpZoomScale = relDS;
            w.tmpZoomX = x;
            w.tmpZoomY = y;
            w.paintImmediately(0, 0, w.getWidth(), w.getHeight());
            w.tmpZoomScale = 1.0;
            w.tmpZoomX = 0;
            w.tmpZoomY = 0;
        }
    }

    private static void zoomHelper3(OpenSlideView w, double relDS) {
        if (w == null) {
            return;
        }
        if (relDS != 1.0) {
            w.paintBackingStore();
        }
    }

    private void registerEventHandlers() {
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                double ds1 = OpenSlideView.zoomHelper(OpenSlideView.this, e.getX(), e.getY(), e.getWheelRotation());
                double ds2 = OpenSlideView.zoomHelper(OpenSlideView.this.otherView, e.getX(), e.getY(), e.getWheelRotation());
                OpenSlideView.zoomHelper2(OpenSlideView.this, ds1, e.getX(), e.getY());
                OpenSlideView.zoomHelper2(OpenSlideView.this.otherView, ds2, e.getX(), e.getY());
                OpenSlideView.zoomHelper3(OpenSlideView.this, ds1);
                OpenSlideView.zoomHelper3(OpenSlideView.this.otherView, ds2);
                OpenSlideView.repaintHelper(OpenSlideView.this);
                OpenSlideView.repaintHelper(OpenSlideView.this.otherView);
            }
        });
        MouseAdapter ma = new MouseAdapter(){
            private SelectionMode selectionMode;
            private int oldX;
            private int oldY;
            private int slideStartX;
            private int slideStartY;
            private Path2D.Double freehandPath;

            @Override
            public void mousePressed(MouseEvent e) {
                OpenSlideView.this.requestFocusInWindow();
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                int ellipseMask = 192;
                int freehandMask = 128;
                int rectMask = 64;
                this.selectionMode = (e.getModifiersEx() & 0xC0) == 192 ? SelectionMode.ELLIPSE : ((e.getModifiersEx() & 0x80) == 128 ? SelectionMode.FREEHAND : ((e.getModifiersEx() & 0x40) == 64 ? SelectionMode.RECT : SelectionMode.NONE));
                this.oldX = e.getX();
                this.oldY = e.getY();
                double ds = OpenSlideView.this.getDownsample();
                this.slideStartX = (int)((double)(this.oldX + ((OpenSlideView)OpenSlideView.this).viewPosition.x) * ds);
                this.slideStartY = (int)((double)(this.oldY + ((OpenSlideView)OpenSlideView.this).viewPosition.y) * ds);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                int relX = this.oldX - e.getX();
                int relY = this.oldY - e.getY();
                double ds = OpenSlideView.this.getDownsample();
                int dx = this.slideStartX;
                int dy = this.slideStartY;
                int dw = (int)((double)(e.getX() + ((OpenSlideView)OpenSlideView.this).viewPosition.x) * ds) - dx;
                int dh = (int)((double)(e.getY() + ((OpenSlideView)OpenSlideView.this).viewPosition.y) * ds) - dy;
                if (dw < 0) {
                    dx += dw;
                    dw = -dw;
                }
                if (dh < 0) {
                    dy += dh;
                    dh = -dh;
                }
                switch (this.selectionMode) {
                    case NONE: {
                        OpenSlideView.translateHelper(OpenSlideView.this, relX, relY);
                        OpenSlideView.translateHelper(OpenSlideView.this.otherView, relX, relY);
                        OpenSlideView.repaintHelper(OpenSlideView.this);
                        OpenSlideView.repaintHelper(OpenSlideView.this.otherView);
                        break;
                    }
                    case RECT: {
                        OpenSlideView.this.selectionBeingDrawn = new Rectangle(dx, dy, dw, dh);
                        OpenSlideView.this.repaint();
                        break;
                    }
                    case FREEHAND: {
                        if (OpenSlideView.this.selectionBeingDrawn == null) {
                            this.freehandPath = new Path2D.Double();
                            OpenSlideView.this.selectionBeingDrawn = this.freehandPath;
                            this.freehandPath.moveTo(this.slideStartX, this.slideStartY);
                        }
                        this.freehandPath.lineTo((double)(e.getX() + ((OpenSlideView)OpenSlideView.this).viewPosition.x) * ds, (double)(e.getY() + ((OpenSlideView)OpenSlideView.this).viewPosition.y) * ds);
                        OpenSlideView.this.repaint();
                        break;
                    }
                    case ELLIPSE: {
                        OpenSlideView.this.selectionBeingDrawn = new Ellipse2D.Double(dx, dy, dw, dh);
                        OpenSlideView.this.repaint();
                    }
                }
                this.oldX = e.getX();
                this.oldY = e.getY();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.selectionMode == SelectionMode.FREEHAND) {
                    this.freehandPath.closePath();
                }
                this.selectionMode = SelectionMode.NONE;
                if (OpenSlideView.this.selectionBeingDrawn != null) {
                    Rectangle bb = OpenSlideView.this.selectionBeingDrawn.getBounds();
                    if (bb.height != 0 && bb.width != 0) {
                        OpenSlideView.this.selections.add(new DefaultAnnotation(OpenSlideView.this.selectionBeingDrawn));
                        OpenSlideView.this.selectionBeingDrawn = null;
                    }
                }
                OpenSlideView.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                OpenSlideView.selectionsVisibleHelper(OpenSlideView.this, true);
                OpenSlideView.selectionsVisibleHelper(OpenSlideView.this.otherView, true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                OpenSlideView.selectionsVisibleHelper(OpenSlideView.this, false);
                OpenSlideView.selectionsVisibleHelper(OpenSlideView.this.otherView, false);
            }
        };
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
        InputMap inputMap = new InputMap();
        ActionMap actionMap = new ActionMap();
        inputMap.put(KeyStroke.getKeyStroke("SPACE"), "center");
        actionMap.put("center", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenSlideView.centerHelper(OpenSlideView.this);
                OpenSlideView.centerHelper(OpenSlideView.this.otherView);
                OpenSlideView.repaintHelper(OpenSlideView.this);
                OpenSlideView.repaintHelper(OpenSlideView.this.otherView);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("UP"), "scroll up");
        inputMap.put(KeyStroke.getKeyStroke("W"), "scroll up");
        actionMap.put("scroll up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenSlideView.translateHelper(OpenSlideView.this, 0, -100);
                OpenSlideView.translateHelper(OpenSlideView.this.otherView, 0, -100);
                OpenSlideView.repaintHelper(OpenSlideView.this);
                OpenSlideView.repaintHelper(OpenSlideView.this.otherView);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), "scroll down");
        inputMap.put(KeyStroke.getKeyStroke("S"), "scroll down");
        actionMap.put("scroll down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenSlideView.translateHelper(OpenSlideView.this, 0, 100);
                OpenSlideView.translateHelper(OpenSlideView.this.otherView, 0, 100);
                OpenSlideView.repaintHelper(OpenSlideView.this);
                OpenSlideView.repaintHelper(OpenSlideView.this.otherView);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), "scroll left");
        inputMap.put(KeyStroke.getKeyStroke("A"), "scroll left");
        actionMap.put("scroll left", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenSlideView.translateHelper(OpenSlideView.this, -100, 0);
                OpenSlideView.translateHelper(OpenSlideView.this.otherView, -100, 0);
                OpenSlideView.repaintHelper(OpenSlideView.this);
                OpenSlideView.repaintHelper(OpenSlideView.this.otherView);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), "scroll right");
        inputMap.put(KeyStroke.getKeyStroke("D"), "scroll right");
        actionMap.put("scroll right", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenSlideView.translateHelper(OpenSlideView.this, 100, 0);
                OpenSlideView.translateHelper(OpenSlideView.this.otherView, 100, 0);
                OpenSlideView.repaintHelper(OpenSlideView.this);
                OpenSlideView.repaintHelper(OpenSlideView.this.otherView);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("L"), "rotate left");
        actionMap.put("rotate left", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("R"), "rotate right");
        actionMap.put("rotate right", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("PLUS"), "zoom in");
        inputMap.put(KeyStroke.getKeyStroke("EQUALS"), "zoom in");
        actionMap.put("zoom in", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double d1 = OpenSlideView.zoomHelper(OpenSlideView.this, -1);
                double d2 = OpenSlideView.zoomHelper(OpenSlideView.this.otherView, -1);
                OpenSlideView.this.zoomHelper2(OpenSlideView.this, d1);
                OpenSlideView.this.zoomHelper2(OpenSlideView.this.otherView, d2);
                OpenSlideView.zoomHelper3(OpenSlideView.this, d1);
                OpenSlideView.zoomHelper3(OpenSlideView.this.otherView, d2);
                OpenSlideView.repaintHelper(OpenSlideView.this);
                OpenSlideView.repaintHelper(OpenSlideView.this.otherView);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("MINUS"), "zoom out");
        actionMap.put("zoom out", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double d1 = OpenSlideView.zoomHelper(OpenSlideView.this, 1);
                double d2 = OpenSlideView.zoomHelper(OpenSlideView.this.otherView, 1);
                OpenSlideView.this.zoomHelper2(OpenSlideView.this, d1);
                OpenSlideView.this.zoomHelper2(OpenSlideView.this.otherView, d2);
                OpenSlideView.zoomHelper3(OpenSlideView.this, d1);
                OpenSlideView.zoomHelper3(OpenSlideView.this.otherView, d2);
                OpenSlideView.repaintHelper(OpenSlideView.this);
                OpenSlideView.repaintHelper(OpenSlideView.this.otherView);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("Z"), "zoom to fit");
        actionMap.put("zoom to fit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenSlideView.this.zoomToFit();
                OpenSlideView.this.centerSlidePrivate();
                OpenSlideView.this.paintBackingStore();
                OpenSlideView.this.repaint();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("1"), "zoom to 1:1");
        actionMap.put("zoom to 1:1", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double d1 = OpenSlideView.zoomHelper(OpenSlideView.this, Integer.MIN_VALUE);
                double d2 = OpenSlideView.zoomHelper(OpenSlideView.this.otherView, Integer.MIN_VALUE);
                OpenSlideView.this.zoomHelper2(OpenSlideView.this, d1);
                OpenSlideView.this.zoomHelper2(OpenSlideView.this.otherView, d2);
                OpenSlideView.zoomHelper3(OpenSlideView.this, d1);
                OpenSlideView.zoomHelper3(OpenSlideView.this.otherView, d2);
                OpenSlideView.repaintHelper(OpenSlideView.this);
                OpenSlideView.repaintHelper(OpenSlideView.this.otherView);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("BACK_QUOTE"), "toggle pins");
        actionMap.put("toggle pins", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenSlideView.this.selectionsAsPins = !OpenSlideView.this.selectionsAsPins;
                if (OpenSlideView.this.otherView != null) {
                    OpenSlideView.this.otherView.selectionsAsPins = !OpenSlideView.this.otherView.selectionsAsPins;
                }
                OpenSlideView.repaintHelper(OpenSlideView.this);
                OpenSlideView.repaintHelper(OpenSlideView.this.otherView);
            }
        });
        InputMap oldInputMap = this.getInputMap();
        ActionMap oldActionMap = this.getActionMap();
        inputMap.setParent(oldInputMap.getParent());
        oldInputMap.setParent(inputMap);
        actionMap.setParent(oldActionMap.getParent());
        oldActionMap.setParent(actionMap);
    }

    protected void zoomHelper2(OpenSlideView w, double d) {
        if (w == null) {
            return;
        }
        OpenSlideView.zoomHelper2(w, d, w.getWidth() / 2, w.getHeight() / 2);
    }

    protected static double zoomHelper(OpenSlideView w, int i) {
        if (w == null) {
            return 1.0;
        }
        return OpenSlideView.zoomHelper(w, w.getWidth() / 2, w.getHeight() / 2, i);
    }

    private void zoomSlide(int mouseX, int mouseY, int amount) {
        double oldDS = this.getDownsample();
        int centerX = mouseX + this.viewPosition.x;
        int centerY = mouseY + this.viewPosition.y;
        double bx = (double)centerX * oldDS;
        double by = (double)centerY * oldDS;
        this.adjustDownsample(amount);
        double newDS = this.getDownsample();
        if (oldDS != newDS) {
            this.viewPosition.translate((int)Math.round(bx / newDS) - centerX, (int)Math.round(by / newDS) - centerY);
        }
    }

    private void adjustDownsample(int amount) {
        this.downsampleExponent += amount;
        if (this.downsampleExponent < 0) {
            this.downsampleExponent = 0;
        } else if (this.downsampleExponent > this.maxDownsampleExponent) {
            this.downsampleExponent = this.maxDownsampleExponent;
        }
    }

    private double getDownsample() {
        return Math.pow(this.downsampleBase, this.downsampleExponent);
    }

    public void centerSlide() {
        this.centerSlidePrivate();
        this.repaint();
    }

    public void setViewPosition(int x, int y) {
        this.translateSlidePrivate(x - this.viewPosition.x, y - this.viewPosition.y);
        this.repaint();
    }

    public void centerOnSelection(int selection) {
        this.centerOnSelectionPrivate(selection);
        this.repaint();
    }

    private void centerOnSelectionPrivate(int s) {
        if (this.selections.isEmpty() || s == -1) {
            this.centerSlidePrivate();
        } else {
            Shape selection = this.selections.get(s).getShape();
            Rectangle2D bb = selection.getBounds2D();
            this.centerSlidePrivate((int)bb.getCenterX(), (int)bb.getCenterY());
        }
    }

    private void centerSlidePrivate() {
        this.centerSlidePrivate((int)(this.osr.getLevel0Width() / 2L), (int)(this.osr.getLevel0Height() / 2L));
    }

    private void centerSlidePrivate(int cX, int cY) {
        Insets insets = this.getInsets();
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getHeight() - insets.top - insets.bottom;
        if (w <= 0 || h <= 0) {
            return;
        }
        int centerX = w / 2 + insets.left;
        int centerY = h / 2 + insets.top;
        double ds = this.getDownsample();
        int centerDX = (int)((double)cX / ds);
        int centerDY = (int)((double)cY / ds);
        int newX = -(centerX - centerDX);
        int newY = -(centerY - centerDY);
        this.translateSlidePrivate(newX - this.viewPosition.x, newY - this.viewPosition.y);
    }

    private void zoomToFit() {
        double hs;
        Insets insets = this.getInsets();
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getHeight() - insets.top - insets.bottom;
        if (w <= 0 || h <= 0) {
            return;
        }
        double ws = (double)this.osr.getLevel0Width() / (double)w;
        double maxS = Math.max(ws, hs = (double)this.osr.getLevel0Height() / (double)h);
        this.downsampleExponent = maxS < 1.0 ? 0 : (int)Math.ceil(Math.log(maxS) / Math.log(this.downsampleBase));
        if (this.downsampleExponent > this.maxDownsampleExponent) {
            this.downsampleExponent = this.maxDownsampleExponent;
        }
    }

    private void rotateSlide(int quads) {
        this.rotation += quads;
        this.rotation %= 4;
        if (this.rotation < 0) {
            this.rotation += 4;
        }
    }

    public void linkWithOther(OpenSlideView otherView) {
        this.otherView = otherView;
        otherView.otherView = this;
    }

    public void unlinkOther() {
        if (this.otherView != null) {
            this.otherView.otherView = null;
            this.otherView = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.firstPaint) {
            if (w != 0 && h != 0) {
                this.createBackingStore();
                if (this.startWithZoomFit) {
                    this.zoomToFit();
                }
                this.centerOnSelectionPrivate(0);
                this.paintBackingStore();
                this.firstPaint = false;
            } else {
                return;
            }
        }
        if (this.dbuf.getWidth() != w || this.dbuf.getHeight() != h) {
            this.createBackingStore();
            this.paintBackingStore();
        }
        Graphics scratchG = g.create();
        Graphics2D g2 = (Graphics2D)scratchG;
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.clipRect(insets.left, insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
            AffineTransform a = g2.getTransform();
            if (this.tmpZoomScale != 1.0) {
                g2.setBackground(this.getBackground());
                g2.clearRect(0, 0, w, h);
                g2.translate(this.tmpZoomX, this.tmpZoomY);
                g2.scale(this.tmpZoomScale, this.tmpZoomScale);
                g2.translate(-this.tmpZoomX, -this.tmpZoomY);
            }
            g2.drawImage((Image)this.dbuf, 0, 0, null);
            g2.setTransform(a);
            if (this.selectionsVisible) {
                g2.setComposite(AlphaComposite.SrcOver);
            } else {
                g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
            }
            this.paintSelection(g2);
        }
        finally {
            scratchG.dispose();
        }
    }

    private void createBackingStore() {
        this.dbuf = this.getGraphicsConfiguration().createCompatibleImage(this.getWidth(), this.getHeight(), 1);
    }

    private void paintBackingStore() {
        Graphics2D dg = this.dbuf.createGraphics();
        dg.setClip(0, 0, this.dbuf.getWidth(), this.dbuf.getHeight());
        this.paintBackingStore(dg);
        dg.dispose();
    }

    private void paintBackingStore(Graphics2D g) {
        double ds = this.getDownsample();
        int offsetX = this.viewPosition.x;
        int offsetY = this.viewPosition.y;
        Rectangle clip = g.getClipBounds();
        g.setBackground(this.getBackground());
        g.clearRect(clip.x, clip.y, clip.width, clip.height);
        try {
            this.osr.paintRegion(g, clip.x, clip.y, offsetX + clip.x, offsetY + clip.y, clip.width, clip.height, ds);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void paintSelection(Graphics2D g, Shape selection, int x, int y, double downsample) {
        OpenSlideView.paintSelection(g, selection, x, y, downsample, false);
    }

    public static void paintSelection(Graphics2D g, Shape selection, int x, int y, double downsample, boolean asPins) {
        AffineTransform at = new AffineTransform();
        at.translate(x, y);
        at.scale(1.0 / downsample, 1.0 / downsample);
        Shape s = at.createTransformedShape(selection);
        if (asPins) {
            Rectangle2D r = s.getBounds2D();
            int sx = (int)Math.round(r.getCenterX());
            int sy = (int)Math.round(r.getCenterY());
            g.setColor(Color.RED);
            g.fillRect(sx - 2, sy - 2, 4, 4);
        } else {
            g.translate(1, 1);
            g.setColor(Color.BLACK);
            g.draw(s);
            g.translate(-1, -1);
            g.setColor(Color.WHITE);
            g.draw(s);
        }
    }

    private void paintSelection(Graphics2D g) {
        if (this.selectionBeingDrawn != null) {
            OpenSlideView.paintSelection(g, this.selectionBeingDrawn, -this.viewPosition.x, -this.viewPosition.y, this.getDownsample(), false);
        }
        for (Annotation selection : this.selections) {
            OpenSlideView.paintSelection(g, selection.getShape(), -this.viewPosition.x, -this.viewPosition.y, this.getDownsample(), this.selectionsAsPins);
        }
    }

    public void addSelection(Shape s) {
        this.selections.add(new DefaultAnnotation(s));
        this.repaint();
    }

    public OpenSlide getOpenSlide() {
        return this.osr;
    }

    public long getSlideX(int x) {
        return (long)((double)(this.viewPosition.x + x) * this.getDownsample());
    }

    public long getSlideY(int y) {
        return (long)((double)(this.viewPosition.y + y) * this.getDownsample());
    }

    public SelectionListModel getSelectionListModel() {
        return this.selections;
    }

    public void setSelectionListModel(SelectionListModel selections) {
        this.selections = selections;
    }

    public int getSelectionForPoint(int x, int y) {
        for (int i = 0; i < this.selections.getSize(); ++i) {
            Shape s = this.selections.get(i).getShape();
            if (!s.contains(new Point(x, y))) continue;
            return i;
        }
        return -1;
    }

    private static enum SelectionMode {
        NONE,
        RECT,
        FREEHAND,
        ELLIPSE;

    }
}

