
wsi_dict = {
    'TCGA-LUAD': [
        'Tumor Cells - Presence of malignant epithelial cells with increased nuclear-cytoplasmic ratio, prominent nucleoli, and irregular nuclear contours.',
        'Nuclear Atypia - Variably shaped and sized nuclei that are often hyperchromatic.',
        'Mitotic Figures - Increased number of mitoses indicating high cellular proliferation.',
        'Necrosis - Areas of cell death within the tumor, often characterized by ghost cells and karyorrhexis.',
        'Lymphovascular Invasion - Tumor cells within blood vessels or lymphatics, indicating potential for metastasis.',
        'Pleural Invasion - Tumor extending into or through the pleura.',
        'Bronchial Wall Invasion - Infiltration of the tumor into walls of bronchi or bronchioles.',
        'Desmoplastic Reaction - Dense fibrous tissue formation around the tumor, a response to invasion.',
        'Leukocyte Infiltration - Presence of immune cells such as lymphocytes and macrophages within or around the tumor.',
        'Mucinous Differentiation - Areas within the tumor showing mucin production.',
        'Papillary Structures - Formation of finger-like projections lined by tumor cells.',
        'Micropapillary Pattern - Small papillary clusters without fibrovascular cores.',
        'Acinar Formation - Well-formed glandular structures by tumor cells.',
        'Solid Growth Pattern - Sheets of tumor cells without glandular or papillary differentiation.',
        'Lepidic Growth - Tumor cells spreading along pre-existing alveolar structures.',
        'Fibrosis - Increased fibrous tissue possibly as a reaction to tumor or indicative of invasive processes.',
        'Granulomas - Nodular inflammatory lesions, could suggest an infectious process or sarcoid-like reaction.',
        'Honeycombing - Alveolar spaces distorted into cystic spaces, often associated with interstitial lung diseases.',
        'Emphysematous Changes - Destruction of alveolar walls leading to airspace enlargement.',
        'Interstitial Inflammation - Infiltration of the interstitial spaces by chronic inflammatory cells.'],
    'TCGA-SARC': ['Cellular Atypia: Abnormal cell sizes or shapes which are significant in identifying malignancy.',
                  'High Nuclear-Cytoplasmic Ratio: Larger nuclei in cells compared to the cytoplasm, often seen in cancerous cells.',
                  'Pleomorphism: Variation in the size and shape of cells and nuclei, indicative of high-grade tumors.',
                  'Increased Mitotic Activity: High numbers of mitotic figures suggest rapid cellular division and malignancy.',
                  'Necrosis: Presence of dead cells and tissues, which can indicate aggressive tumor growth.',
                  'Loss of Cell Polarity: Disorganized arrangement of cells, losing normal tissue architecture.',
                  'Invasive Growth Pattern: Tumor cells invading surrounding tissues.',
                  'Vascular Invasion: Tumor cells found in blood vessels, suggesting potential for metastasis.',
                  'Perineural Invasion: Tumor involvement around nerves, often associated with aggressive behavior.',
                  'Hyperchromasia: Darkly stained nuclei, indicating high DNA content.',
                  'Fibrous Stroma: Increase in fibrous connective tissue supporting the tumor.',
                  'Tumor Giant Cells: Large, multinucleated cells, often seen in high-grade sarcomas.',
                  'Hemorrhage: Blood leakage within the tumor, can indicate tumor growth or necrosis.',
                  'Calcifications: Mineral deposits in the tissue, sometimes associated with certain tumor types.',
                  'Lymphocytic Infiltration: Presence of immune cells within the tumor, which can suggest an immune response to the tumor.',
                  'Mucinous Degeneration: Accumulation of mucin in tumor cells, seen in some soft tissue tumors.',
                  'Spindle Cell Morphology: Elongated cells that are characteristic of certain sarcomas like leiomyosarcoma.',
                  'Epithelioid Cells: Rounded cells that resemble epithelial cells, seen in epithelioid sarcomas.',
                  'Clear Cells: Cells with clear, empty-looking cytoplasm, characteristic of certain types of sarcoma.',
                  'Lipoblasts: Indicator of liposarcoma, these are fat cells with atypical features.'],
    'TCGA_BRCA': [
        'Ductal Carcinoma In Situ (DCIS): Proliferation of malignant cells within the milk ducts without invasion into surrounding tissue.',
        'Invasive Ductal Carcinoma (IDC): Cancer cells breaking through the ductal wall and invading the surrounding breast tissue.',
        'Lobular Carcinoma In Situ (LCIS): Abnormal cell growth confined within the lobules of the breast.',
        'Invasive Lobular Carcinoma (ILC): Cancer cells spread from the lobules to adjacent breast tissues.',
        'Tubular Formation: Degree of tubule formation by tumor cells, which influences grading.',
        'Nuclear Pleomorphism: Variation in size and shape of the nuclei in the tumor cells, used for grading the tumor.',
        'Mitotic Count: Number of dividing cells present, indicating tumor aggressiveness.',
        'Necrosis: Presence of dead cells within the tumor, suggesting higher tumor grade.',
        'Calcifications: Small calcium deposits found within the breast tissue, often visible in both benign and malignant conditions.',
        'Fibrosis: Formation of fibrous tissue, which can be reactive or associated with tumor stroma.',
        'Inflammatory Infiltrate: Presence of immune cells within the tumor or surrounding tissue, which may influence prognosis.',
        'Lymphovascular Invasion: Tumor cells seen within lymphatic or blood vessels, indicating potential for metastasis.',
        'Perineural Invasion: Cancer cells invading nerves in the breast, often associated with higher stage cancer.',
        'Mucinous Differentiation: Presence of mucus-producing cancer cells, typically seen in mucinous carcinoma.',
        'Papillary Structures: Finger-like projections found in some tumors, characteristic of papillary carcinoma.',
        'Cribriform Pattern: Perforated or sieve-like growth pattern typical of certain carcinomas like DCIS.',
        'Triple-Negative Breast Cancer: Lack of estrogen receptor, progesterone receptor, and HER2/neu expression.',
        'HER2-Positive Cancer: Overexpression of HER2/neu gene leading to more aggressive cancer.',
        'Estrogen Receptor (ER) Positive: Tumors that express estrogen receptors and may respond to hormone therapy.',
        'Progesterone Receptor (PR) Positive: Tumors that express progesterone receptors, influencing treatment options.'],
    'TCGA-THCA': [
        'Papillary Structures: Characteristic branching papillary formations with fibrovascular cores, suggestive of papillary thyroid carcinoma (PTC).',
        'Psammoma Bodies: Concentrically calcified structures often seen in PTC.',
        'Orphan Annie Eye Nuclei: Large, empty-appearing nuclei with marginalization of chromatin commonly found in PTC.',
        'Intracellular Colloid: Droplets of colloid within follicular cells, indicative of PTC.',
        'Nuclear Grooves: Elongated indentations in the nuclear membrane, typical in PTC.',
        'Nuclear Pseudoinclusions: Cytoplasmic invaginations into the nucleus observed in PTC.',
        'Follicular Pattern: Microfollicular or trabecular growth pattern, potentially pointing to follicular thyroid carcinoma (FTC) or follicular variant of PTC.',
        'Colloid Scarcity: Reduced colloid in follicles, which might indicate hyperactivity or neoplasia.',
        'Capsular Invasion: Breach of the thyroid capsule by tumor cells, often seen in FTC.',
        'Vascular Invasion: Presence of tumor cells in blood vessels, confirming invasive carcinoma.',
        'Hurthle Cells: Large cells with granular eosinophilic cytoplasm and prominent nucleoli, possibly indicating Hurthle cell carcinoma.',
        'Lymphocytic Infiltration: Presence of lymphocytes, suggestive of lymphocytic thyroiditis or Hashimoto’s thyroiditis.',
        'Cystic Changes: Formation of cysts within the thyroid, sometimes seen in benign conditions or degenerative cancer areas.',
        'Fibrosis: Increased fibrous tissue, which could be part of a benign or malignant process.',
        'Oncocytic Changes: Cells with abundant, granular, eosinophilic cytoplasm, seen in oncocytic (Hurthle cell) adenomas or carcinomas.',
        'Multinucleated Giant Cells: Can indicate a more aggressive tumor or granulomatous disease.',
        'Amyloid Deposition: Presence of amyloid in medullary thyroid carcinoma.',
        'Neuroendocrine Architecture: Patterns suggestive of medullary thyroid carcinoma.',
        'Calcitonin Granules: Intracellular granules seen in medullary thyroid carcinoma.',
        'Tumor Necrosis: Areas of necrotic tissue within the tumor, indicating high tumor grade.'],
    'TCGA-ESCA': [
        'Dysplasia - Abnormal cellular organization or differentiation, which can be mild, moderate, or severe.',
        'Intraepithelial neoplasia - Presence of neoplastic cells within the epithelial layer without invasion into the submucosal layers.',
        'Carcinoma in situ - A severe form of dysplasia confined to the epithelium.',
        'Squamous cell carcinoma - Malignant tumors derived from squamous epithelial cells.',
        'Adenocarcinoma - Cancer cells forming glandular structures originating in glandular epithelium.',
        'Basal cell hyperplasia - Increase in the number of basal cells in the squamous epithelium.',
        'Lymphocytic infiltration - Presence of lymphocytes within the tumor or surrounding tissue, indicating immune response.',
        'Muscularis propria invasion - Tumor invasion into the muscular layer of the esophagus.',
        'Perineural invasion - Cancer cells seen along or invading nerves.',
        'Vascular invasion - Tumor cells invading into blood vessels.',
        'Mitotic figures - High numbers of cells undergoing division, indicating rapid cell proliferation.',
        'Anaplasia - Cells exhibiting loss of differentiation.',
        'Necrosis - Areas of cell death within the tumor.',
        'Fibrosis - Thickening and scarring of tissue due to injury or long-term inflammation.',
        'Acid mucin production - Presence of acid mucins in glandular tumors, detected by special staining.',
        'Keratinization - Formation of keratin by squamous cells, often seen in well-differentiated squamous cell carcinoma.',
        'Intestinal metaplasia - Presence of intestinal epithelium in the esophagus (Barrett’s esophagus).',
        'Submucosal gland involvement - Tumor invasion into submucosal glands.',
        'Lymph node metastasis - Spread of cancer cells to regional lymph nodes.',
        'Polypoid growth - Tumor growth projecting into the esophageal lumen.'],
    'TCGA-UCEC': [
        'Atypical Glandular Proliferation: Abnormal growth of the endometrial glands, potentially a precursor to cancer.',
        'Hyperplasia Without Atypia: Increased number of cells without cellular abnormalities, often a benign condition.',
        'Hyperplasia With Atypia: Proliferation of abnormal cells, which may lead to cancer.',
        'Endometrioid Carcinoma: A common type of endometrial cancer with glandular features resembling the lining of the uterus.',
        'Serous Carcinoma: A more aggressive, high-grade carcinoma with serous features.',
        'Clear Cell Carcinoma: Characterized by cells with clear, empty-looking cytoplasm and aggressive behavior.',
        'Squamous Differentiation: Presence of squamous cells in the tumor, indicative of certain types of endometrial carcinoma.',
        'Carcinosarcoma (Malignant Mixed Müllerian Tumor): A rare form of cancer with both carcinomatous and sarcomatous components.',
        'Leiomyoma Invasion: Invasion of benign smooth muscle tumors (fibroids) by malignant cells.',
        'Lymphovascular Invasion: Cancer cells found within blood vessels or lymphatics, suggesting potential for metastasis.',
        'Necrosis: Areas of dead tissue, often found in rapidly growing tumors.',
        'High Mitotic Index: High number of cells undergoing division, indicating rapid tumor growth.',
        'Poorly Differentiated Cells: Cells that lack normal architectural features, indicative of high-grade tumors.',
        'Myometrial Invasion: Depth of tumor invasion into the uterine muscle, important for staging and prognosis.',
        'Perineural Invasion: Cancer cells surrounding or invading nerve fibers, a poor prognostic factor.',
        'Stromal Invasion: Invasion of the supporting connective tissue of the endometrium.',
        'Calcifications: Mineral deposits that may be seen in chronic conditions or in areas of necrosis.',
        'Fibrosis: Thickening and scarring of connective tissue, often as a response to injury.',
        'Chronic Inflammation: Presence of inflammatory cells over a long period, can support a cancerous environment.',
        'Acute Inflammation: Sudden influx of inflammatory cells, potentially indicating infection or recent tissue damage.'],
    'TCGA-COAD': ['Tumor Cellularity: High density of tumor cells compared to normal tissue.',
                  'Nuclear Atypia: Variation in nuclear size and shape among tumor cells, often enlarged and irregular.',
                  'Increased Mitotic Activity: High number of cells undergoing mitosis.',
                  'Loss of Polarity: Disorganized arrangement of cells, losing normal tissue architecture.',
                  'Invasion of Tumor into Adjacent Structures: Penetration of tumor cells into nearby tissues or structures.',
                  'Necrosis: Areas of dead cells within the tumor due to inadequate blood supply.',
                  'Mucinous Features: Presence of mucin-producing cancer cells.',
                  'Signet Ring Cells: Cells that contain large vacuoles, displacing the nucleus to the periphery.',
                  'Lymphovascular Invasion: Tumor cells within lymphatic or blood vessels, indicating potential for metastasis.',
                  'Perineural Invasion: Cancer spread along nerves within the bowel wall.',
                  'Desmoplastic Reaction: Dense fibrous tissue response around the tumor.',
                  'Crypt Architecture Distortion: Abnormal shape and arrangement of colonic crypts.',
                  'High Grade Dysplasia: Severe precancerous changes in cells lining the colon.',
                  'Adenomatous Polyps: Benign neoplasms that may show dysplastic changes.',
                  'Serrated Pathway Lesions: Including hyperplastic polyps and sessile serrated lesions which may progress to cancer.',
                  'Budding Tumor Cells: Individual or small clusters of cancer cells at the invasive front.',
                  'Margin Status: Evaluation of the edges of resected tissue for presence of cancer cells.',
                  'Lymph Node Metastasis: Presence of cancer cells in lymph nodes.',
                  'Chronic Inflammation: Long-standing inflammation, often associated with conditions like inflammatory bowel disease.',
                  'Acute Inflammation: Presence of neutrophils within the tissue, indicating active inflammation.'],
    'TCGA-CESC': ['Nuclear Pleomorphism: Variation in the size and shape of nuclei, indicative of malignancy.',
                  'Hyperchromasia: Dark-staining nuclei, suggesting increased DNA content and malignancy.',
                  'Increased Mitotic Activity: Higher than normal number of cells undergoing division, a sign of rapid cell proliferation.',
                  'Abnormal Mitotic Figures: Irregular mitotic figures, indicative of dysregulated cell division.',
                  'Loss of Polarity: Disorganization of cells, losing their normal alignment and orientation.',
                  'Keratin Pearls: Concentric layers of keratinized cells, typically seen in well-differentiated squamous cell carcinoma.',
                  'Intercellular Bridges: Cytoplasmic connections between squamous cells, indicating squamous differentiation.',
                  'Necrosis: Areas of dead cells, often seen in high-grade malignancies.',
                  'Desmoplasia: Fibrous tissue formation around a tumor, indicative of invasive carcinoma.',
                  'Invasion into Surrounding Tissues: Tumor cells infiltrating adjacent stromal tissues.',
                  'Glandular Differentiation: Formation of gland-like structures, characteristic of adenocarcinoma.',
                  'Papillary Structures: Finger-like projections, often seen in some adenocarcinomas.',
                  'Cytoplasmic Vacuolation: Presence of vacuoles within the cytoplasm, which can indicate cell damage or degeneration.',
                  'Perineural Invasion: Tumor cells encroaching around nerves, a sign of aggressive malignancy.',
                  'Lymphovascular Invasion: Tumor cells invading lymphatic or blood vessels, suggesting potential for metastasis.',
                  'Lymphocytic Infiltrate: Presence of lymphocytes, indicating an immune response, which can be reactive or associated with a tumor.',
                  'Squamous Metaplasia: Transformation of glandular epithelium into squamous epithelium, which can be a precursor to dysplasia.',
                  'CIN (Cervical Intraepithelial Neoplasia): Graded I-III based on severity, indicative of pre-cancerous changes.',
                  'Koilocytosis: Presence of koilocytes, which are cells with perinuclear clearing and irregular nuclear contours, often associated with HPV infection.',
                  'Microinvasion: Small clusters of invasive carcinoma cells breaking through the basement membrane.'],
    'TCGA-KIRC': [
        'Clear Cell Features: Presence of cells with clear cytoplasm, a hallmark of clear cell renal cell carcinoma (ccRCC).',
        'Nuclear Atypia: Variation in nuclear size and shape, indicating malignant transformation.',
        'High Nuclear Grade: Prominent nucleoli and increased nuclear-cytoplasmic ratio, suggestive of aggressive disease.',
        'Hyperchromatic Nuclei: Dark-staining nuclei indicative of increased DNA content.',
        'Mitoses: Increased mitotic figures pointing to high cellular proliferation.',
        'Necrosis: Areas of cell death, which can indicate high tumor grade and poor prognosis.',
        'Vascular Invasion: Tumor cells within blood vessels, a sign of metastatic potential.',
        'Lymphatic Invasion: Tumor cells within lymphatic vessels, also indicating potential for metastasis.',
        'Sarcomatoid Differentiation: Areas where the tumor resembles sarcoma, associated with worse prognosis.',
        'Tubulocystic Features: Dilated tubules and cysts lined by clear cells.',
        'Solid Growth Pattern: Tumor forming solid sheets of cells without glandular structures.',
        'Papillary Architecture: Finger-like projections of tumor cells, uncommon in ccRCC but can occur.',
        'Foamy Macrophages: Lipid-laden macrophages within the tumor.',
        'Hyalinized Stroma: Presence of dense, pink, glassy connective tissue.',
        'Fibrosis: Increased fibrous connective tissue within the tumor, indicating chronic damage.',
        'Hemorrhage: Presence of blood within the tissue, which can complicate the tumor environment.',
        'Inflammatory Infiltrate: Presence of immune cells like lymphocytes, plasma cells, and macrophages.',
        'Peritumoral Pseudocapsule: A fibrous capsule surrounding the tumor.',
        'Edema: Fluid accumulation in the tissue, indicating inflammation or lymphatic obstruction.',
        'Cystic Change: Fluid-filled spaces within the tumor or kidney parenchyma.'],
    'TCGA-LUSC': ['Keratin Pearls: Concentric layers of keratinized cells, characteristic of squamous cell carcinoma.',
                  'Intercellular Bridges: Desmosomal connections between squamous cells, indicative of squamous differentiation.',
                  'Pleomorphism: Variation in size and shape of cells and nuclei, indicating malignancy.',
                  'Hyperchromasia: Darkly stained nuclei due to increased DNA content, common in cancer cells.',
                  'Mitoses: Increased number of mitotic figures, suggesting high cellular proliferation.',
                  'Atypical Mitoses: Abnormally shaped mitotic figures, indicating genetic instability.',
                  'Necrosis: Areas of cell death, often seen in rapidly growing tumors.',
                  'Invasion: Tumor cells infiltrating surrounding tissues, a hallmark of malignancy.',
                  'Desmoplasia: Fibrous tissue formation in response to tumor invasion.',
                  'Lymphovascular Invasion: Tumor cells present in lymphatic or blood vessels, indicating potential for metastasis.',
                  'Perineural Invasion: Tumor cells surrounding or invading nerves.',
                  'Basement Membrane Disruption: Loss of the normal boundary between epithelial cells and underlying tissue.',
                  'Stromal Reaction: Changes in the supportive tissue, including inflammation and fibrosis.',
                  'Inflammatory Infiltrate: Presence of immune cells, such as lymphocytes and macrophages, often a response to the tumor.',
                  'Granuloma Formation: Aggregates of macrophages, possibly indicating a chronic inflammatory response.',
                  'Squamous Dysplasia: Pre-cancerous changes in squamous cells, with varying degrees of atypia.',
                  'Carcinoma In Situ: Cancer cells confined to the epithelium without invasion.',
                  'Papillary Structures: Finger-like projections of tumor cells, seen in some carcinomas.',
                  'Solid Sheets of Cells: Dense aggregates of tumor cells, lacking glandular or papillary structures.',
                  'Glandular Differentiation: Presence of gland-like structures, suggesting adenosquamous carcinoma.'],
    'TCGA-LIHC': [
        'Nuclear Atypia: Variation in nuclear size and shape, hyperchromasia (dark-staining nuclei), and irregular nuclear contours',
        'Increased Nucleus-to-Cytoplasm Ratio: Enlarged nuclei relative to the amount of cytoplasm',
        'Mitoses: Increased number of mitotic figures, indicating rapid cell division',
        'Anisonucleosis: Variation in nuclear size among cells',
        'Nucleolar Enlargement: Prominent nucleoli within the nuclei',
        'Cytoplasmic Changes: Granular, eosinophilic cytoplasm or clear cytoplasmic changes',
        'Bile Production: Presence of bile pigment within the cytoplasm of hepatocytes',
        'Intracytoplasmic Mallory-Denk Bodies: Eosinophilic cytoplasmic inclusions',
        'Fatty Change (Steatosis): Accumulation of lipid droplets within hepatocytes',
        'Cellular Dysplasia: Pre-cancerous changes with abnormal cellular architecture',
        'Architectural Distortion: Disruption of normal hepatic architecture',
        'Trabecular Pattern: Thickened trabeculae (cords of liver cells) more than two cells thick',
        'Pseudoacinar Structures: Formation of gland-like structures by hepatocytes',
        'Sinusoidal Dilatation: Widening of liver sinusoids',
        'Fibrosis: Increased fibrous tissue, often seen as bridging fibrosis or cirrhosis',
        'Necrosis: Areas of cell death within the liver tissue',
        'Inflammation: Presence of inflammatory cells, such as lymphocytes, plasma cells, and macrophages',
        'Cholestasis: Bile stasis within liver cells or bile ducts',
        'Bile Duct Proliferation: Increase in the number of bile ducts',
        'Vascular Invasion: Tumor cells invading blood vessels'],
    'TCGA-STAD': [
        'Glandular Dysplasia: Abnormalities in the size, shape, and organization of gastric glands, often a precursor to carcinoma.',
        'Invasive Adenocarcinoma: Presence of malignant glandular structures infiltrating beyond the mucosa into the submucosa or deeper layers.',
        'Signet Ring Cells: Malignant cells with prominent intracytoplasmic mucin pushing the nucleus to the periphery, indicative of diffuse-type adenocarcinoma.',
        'Intestinal Metaplasia: Replacement of gastric epithelium with intestinal-type epithelium, a risk factor for gastric cancer.',
        'Atrophic Gastritis: Thinning of the gastric mucosa with loss of gastric glandular cells.',
        'Chronic Inflammation: Presence of lymphocytes and plasma cells in the lamina propria, indicating ongoing inflammation.',
        'Lymphoid Aggregates: Collections of lymphocytes, often seen in chronic gastritis and associated with H. pylori infection.',
        'Neutrophilic Infiltration: Presence of neutrophils within the epithelium or lamina propria, often indicating active inflammation or infection.',
        'Mucosal Erosion or Ulceration: Loss of the epithelial surface layer, leading to exposure of the underlying tissue.',
        'Reactive Gastropathy: Epithelial changes including foveolar hyperplasia and mucin depletion due to chemical injury or bile reflux.',
        'Desmoplasia: Dense fibrous tissue response surrounding invasive cancer cells, indicating stromal reaction to invasive carcinoma.',
        'Lymphovascular Invasion: Presence of tumor cells within lymphatic or blood vessels, a sign of metastatic potential.',
        'Perineural Invasion: Cancer cells surrounding or tracking along nerve fibers, associated with aggressive behavior.',
        'Mucinous Carcinoma: Tumor with abundant extracellular mucin, forming more than 50% of the tumor volume.',
        'Poorly Differentiated Carcinoma: Lack of glandular formation and high-grade nuclear atypia, indicating high-grade malignancy.',
        'Micropapillary Carcinoma: Small clusters of tumor cells within clear spaces mimicking lymphovascular invasion.',
        'Tumor Necrosis: Areas of cell death within the tumor, often due to rapid growth and insufficient blood supply.',
        'Papillary Carcinoma: Tumor with finger-like projections lined by malignant epithelial cells.',
        'Linitis Plastica: Thickened and rigid stomach wall due to diffuse infiltration by malignant cells, characteristic of diffuse-type gastric cancer.',
        'Epithelial Hyperplasia: Increased number of epithelial cells, often seen in regenerative processes.'],
    'TCGA-PRAD': ['Adenocarcinoma: Malignant glandular cells with prominent nucleoli',
                  'Prostatic Intraepithelial Neoplasia (PIN): Precancerous condition with abnormal epithelial cells within the prostate ducts',
                  'Cribriform Pattern: Glandular structures forming sieve-like patterns, indicating a higher grade of cancer',
                  'Gleason Patterns: Scoring based on the architectural patterns of prostate cancer cells (Gleason grades 1-5)',
                  'Perineural Invasion: Cancer cells surrounding or invading nerve fibers',
                  'Lymphovascular Invasion: Cancer cells invading lymphatic or blood vessels',
                  'Mitoses: Increased number of mitotic figures indicating rapid cell division',
                  'Nuclear Atypia: Abnormalities in nuclear size, shape, and chromatin pattern',
                  'Hyperchromasia: Increased staining intensity of cell nuclei due to dense chromatin',
                  'Nucleomegaly: Enlarged nuclei, a common feature in cancer cells',
                  'Prominent Nucleoli: Large and conspicuous nucleoli, often seen in malignant cells',
                  'Basal Cell Layer Disruption: Absence or disruption of the basal cell layer, which normally lines the glands',
                  'Fibromuscular Stroma Invasion: Cancer cells invading the surrounding fibromuscular stroma',
                  'Inflammatory Infiltrate: Presence of immune cells such as lymphocytes and macrophages, indicating a host response',
                  'Atrophy: Shrinkage of prostate glandular structures',
                  'Foamy Gland Carcinoma: Cancer cells with abundant foamy cytoplasm',
                  'Mucinous Carcinoma: Cancer cells with significant mucin production',
                  'Necrosis: Areas of dead cells within the tumor, indicating aggressive behavior',
                  'Squamous Differentiation: Presence of squamous cells within the prostate, which is abnormal',
                  'Clear Cell Features: Cells with clear cytoplasm, seen in certain subtypes of prostate cancer'],
    'TCGA-UVM': ['Increased Cellular Density: Dense clustering of cells indicating a tumor.',
                 'Atypical Melanocytes: Presence of melanocytes with irregular shapes and sizes.',
                 'Pleomorphism: Variation in size and shape of cells and their nuclei, suggestive of malignancy.',
                 'Hyperchromatic Nuclei: Darkly stained nuclei due to increased DNA content.',
                 'Prominent Nucleoli: Enlarged and conspicuous nucleoli within the nuclei.',
                 'Mitoses: Increased number of mitotic figures indicating rapid cell division.',
                 'Spindle-shaped Cells: Spindle cell morphology often seen in spindle cell melanoma.',
                 'Epithelioid Cells: Large, polygonal cells with abundant cytoplasm, typical of more aggressive melanoma.',
                 'Nuclear Molding: Nuclei that appear to press into one another, indicative of high cellularity.',
                 'Intratumoral Lymphocytes: Presence of lymphocytes within the tumor, potentially indicating an immune response.',
                 'Necrosis: Areas of dead cells within the tumor due to insufficient blood supply.',
                 'Inflammatory Infiltrate: Infiltration of inflammatory cells such as lymphocytes and macrophages.',
                 'Pigment Laden Macrophages: Macrophages containing melanin pigment.',
                 'Tumor-Infiltrating Lymphocytes (TILs): Lymphocytes within the tumor, possibly associated with prognosis.',
                 'Vascular Invasion: Tumor cells invading blood vessels.',
                 'Lymphatic Invasion: Tumor cells invading lymphatic vessels.',
                 'Sclerotic Changes: Thickening and hardening of connective tissue.',
                 'Stromal Desmoplasia: Dense, fibrous tissue response surrounding the tumor.',
                 'Perivascular Growth: Tumor cells growing around blood vessels.',
                 'Hemorrhage: Bleeding within the tissue, indicating vascular damage.'],
    'TCGA-OV': [
        'Serous Carcinoma: Presence of high-grade serous carcinoma, characterized by papillary structures, solid sheets of cells, and slit-like glandular spaces.',
        'Clear Cell Carcinoma: Clear cells with abundant cytoplasm and hobnail cells lining the glandular spaces.',
        'Endometrioid Carcinoma: Glandular architecture resembling endometrial tissue, often with squamous differentiation.',
        'Mucinous Carcinoma: Large cystic spaces filled with mucin and lined by mucin-producing epithelial cells.',
        'Transitional Cell Carcinoma: Resemblance to urothelial carcinoma with nested and trabecular growth patterns.',
        'Ovarian Stromal Tumor: Neoplastic proliferation of stromal cells, often with fibrous or thecomatous features.',
        'Granulosa Cell Tumor: Presence of Call-Exner bodies, which are small, follicle-like structures.',
        'Sertoli-Leydig Cell Tumor: Tubules and solid clusters of Sertoli cells and interspersed Leydig cells.',
        'Metastatic Tumors: Secondary tumors from other organs, such as breast or gastrointestinal tract, often with distinct morphology from primary ovarian neoplasms.',
        'Benign Cystadenoma: Simple cystic structures lined by benign epithelium.',
        'Borderline Tumor: Atypical proliferative tumor with features between benign and malignant, lacking stromal invasion.',
        'Papillary Structures: Papillae with fibrovascular cores, seen in serous tumors.',
        'Nuclear Atypia: Enlarged, irregular nuclei with prominent nucleoli, indicative of malignancy.',
        'Mitotic Figures: High mitotic activity suggesting aggressive tumor behavior.',
        'Necrosis: Areas of cell death, often seen in high-grade tumors.',
        'Inflammatory Infiltrate: Presence of immune cells indicating inflammation, which may accompany or obscure neoplastic processes.',
        'Psammoma Bodies: Calcified structures often seen in serous carcinoma.',
        'Desmoplastic Reaction: Fibrous tissue response around invasive carcinoma.',
        'Vascular Invasion: Tumor cells invading blood vessels, indicating a higher risk of metastasis.',
        'Lymphatic Invasion: Tumor cells within lymphatic vessels, suggesting potential for lymphatic spread.'],
    'TCGA-READ': ['Adenocarcinoma: Presence of malignant glandular structures indicating colorectal cancer.',
                  'Mucinous carcinoma: Tumor cells producing excessive mucin, a subtype of colorectal cancer.',
                  'Signet ring cells: Cells with large vacuoles displacing the nucleus, associated with aggressive colorectal cancer.',
                  'Poorly differentiated carcinoma: Lack of gland formation and marked cellular atypia indicating high-grade tumor.',
                  'Moderately differentiated carcinoma: Intermediate gland formation and cellular atypia.',
                  'Well-differentiated carcinoma: Tumor forming well-structured glands.',
                  'Lymphovascular invasion: Tumor cells invading lymphatic and blood vessels, indicating metastatic potential.',
                  'Perineural invasion: Tumor cells surrounding or invading nerves.',
                  'Lymph node metastasis: Tumor cells present in regional lymph nodes.',
                  'Tumor budding: Small clusters of dedifferentiated cells at the invasive front of the tumor.',
                  'Necrosis: Areas of dead tumor cells due to insufficient blood supply.',
                  'Desmoplasia: Fibrous tissue response around the tumor, often seen in invasive cancer.',
                  'High mitotic rate: Increased number of cells undergoing division, indicative of aggressive tumor growth.',
                  'Inflammatory infiltrate: Presence of immune cells, which can indicate a response to the tumor or an inflammatory condition.',
                  'Chronic colitis: Chronic inflammation of the colon, possibly predisposing to cancer.',
                  'Ulceration: Loss of mucosal surface, potentially indicating aggressive disease.',
                  'Dysplasia: Precancerous changes in the epithelium, with varying grades (low-grade, high-grade).',
                  'Polyp: Benign growths that can be precancerous (e.g., adenomatous polyps).',
                  'Hyperplastic polyps: Usually benign, non-precancerous polyps.',
                  'Tubular adenoma: A type of polyp with a risk of becoming cancerous.'],
    'TCGA-PCPG': ['Hypercellularity: An increase in cell density often observed in neoplastic conditions.',
                  'Pleomorphism: Variation in size and shape of cells, indicative of malignancy.',
                  'Increased nuclear to cytoplasmic ratio: Commonly seen in cancer cells.',
                  'Prominent nucleoli: Can be a feature of malignancy.',
                  'Nuclear hyperchromasia: Darkly stained nuclei, indicating high DNA content.',
                  'Mitotic figures: Presence of cells in mitosis, indicative of active cell division.',
                  'Necrosis: Areas of cell death, which may suggest aggressive tumor behavior.',
                  'Hemorrhage: Blood leakage, potentially indicative of tumor invasion into blood vessels.',
                  'Capsular invasion: Tumor penetration into the capsule of the adrenal gland.',
                  'Vascular invasion: Tumor cells invading blood vessels, a sign of potential metastasis.',
                  'Perineural invasion: Tumor spread along nerve sheaths.',
                  'Lymphocytic infiltration: Presence of immune cells, which can be a response to tumor.',
                  'Fibrosis: Thickening and scarring of connective tissue.',
                  'Cystic changes: Formation of cysts within the tumor.',
                  'Deposition of amyloid: Proteinaceous deposits that may appear in some tumor types.',
                  'Oncocytic changes: Presence of cells with abundant, granular, eosinophilic cytoplasm.',
                  'Adrenal cortical hyperplasia: Thickening of the cortex, which may be reactive or part of an endocrine syndrome.',
                  'Angiogenesis: New blood vessel formation within the tumor.',
                  'Loss of normal adrenal architecture: Disruption of the usual zonal organization.',
                  'Spindle cell regions: Areas containing elongated fibroblast-like cells.'],
    'TCGA-BLCA': [
        'High Nuclear-to-Cytoplasmic Ratio - A common sign of malignancy, indicating increased nuclear activity.',
        'Prominent Nucleoli - Often seen in malignant cells, reflecting active protein synthesis.',
        'Irregular Nuclear Contours - Nuclear pleomorphism, which is characteristic of cancer cells.',
        'Increased Mitotic Activity - Higher frequency of cell division, indicating rapid cellular proliferation.',
        'Loss of Polarity - Disorganized arrangement of cells, typical in high-grade tumors.',
        'Necrosis - Areas of cell death within the tumor, often due to rapid growth outstripping blood supply.',
        'Invasive Growth Pattern - Tumor cells invading surrounding tissues, a hallmark of malignancy.',
        'Lymphovascular Invasion - Presence of cancer cells within lymphatic or blood vessels, suggesting potential for metastasis.',
        'Muscularis Propria Invasion - Depth of invasion into bladder wall, important for staging bladder cancer.',
        'Variation in Cell Size (Anisocytosis) - Uneven cell sizes, a feature of dysplasia or malignancy.',
        'Variation in Cell Shape (Pleomorphism) - Irregular cell shapes, indicating abnormal cell development.',
        'Inflammation - Presence of inflammatory cells, which can be reactive or associated with tumor invasion.',
        'Fibrovascular Cores - Structures within papillary tumors, consisting of fibrous tissue and blood vessels.',
        'Calcifications - Mineral deposits that can occur in both benign and malignant conditions.',
        'Carcinoma In Situ (CIS) - A severe dysplastic state without invasion, a precursor to invasive carcinoma.',
        'Squamous Metaplasia - Abnormal transformation of bladder lining into squamous cells, potentially pre-malignant.',
        'Keratinizing Dysplasia - Presence of keratin in dysplastic cells, sometimes seen in squamous differentiation.',
        'Urothelial Atypia - Abnormal urothelial cells, can be reactive or indicative of dysplasia.',
        'Interstitial Cystitis - Chronic inflammation of the bladder wall, can mimic or coexist with carcinoma.',
        'Granulomatous Reaction - Formation of granulomas in the bladder, can be due to infection or other causes.'],
    'TCGA-LGG': ['Hypercellularity: Increased density of cells suggesting neoplastic proliferation.',
                 'Nuclear Atypia: Abnormal size and shape of nuclei which indicates malignancy.',
                 'Mitotic Activity: Presence of numerous mitotic figures indicative of high cellular turnover.',
                 'Necrosis: Dead tissue areas surrounded by viable tumor cells, often in a pseudopalisading pattern.',
                 'Microvascular Proliferation: Formation of new capillary loops within the tumor, a hallmark of high-grade gliomas.',
                 'Infiltrative Margins: Tumor cells spreading into adjacent normal brain tissue.',
                 'Rosenthal Fibers: Eosinophilic, corkscrew fibers found in pilocytic astrocytomas.',
                 'Eosinophilic Granular Bodies: Small, eosinophilic, round structures in the tumor matrix.',
                 'Oligodendroglial Component: Presence of cells with a ‘fried egg’ appearance, typical in oligodendrogliomas.',
                 'Calcifications: Mineral deposits within the tumor.',
                 'Perineuronal Satellitosis: Tumor cells clustering around neurons.',
                 'Perivascular Lymphocytic Infiltration: Immune cells surrounding blood vessels within the tumor.',
                 'Mucoid Degeneration: Accumulation of mucoid material within the tumor.',
                 'Astrocytic Component with Fibrillary Background: Presence of stellate-shaped cells with a fibrillary cytoplasmic background.',
                 'Glioblastoma Multiforme Features: Presence of glomeruloid vascular proliferation and/or necrosis with pseudopalisading, indicating possible higher-grade transformation.',
                 'Subependymal Spread: Tumor spread along ventricular surfaces.',
                 'Subpial Spread: Tumor invasion under the pia mater.',
                 'Chromosome Abnormalities: Abnormal chromosomal features evident in tumor cells.',
                 'Loss of Cellular Cohesion: Disorganization and loss of regular architecture.',
                 'Iron Deposition: Localized iron accumulation, sometimes related to previous hemorrhage.'],
    'TCGA-PAAD': ['Ductal Structures - Irregular, distorted ductal structures with infiltrative growth patterns.',
                  'Mucin Production - Presence of mucin within tumor cells or extracellularly, typical in some pancreatic cancer subtypes.',
                  'Desmoplasia - Dense fibrous stroma surrounding the tumor cells, a hallmark of pancreatic cancer.',
                  'Nuclear Atypia - Enlarged, hyperchromatic nuclei with prominent nucleoli.',
                  'Mitotic Figures - High number of cells undergoing mitosis, indicating rapid cell proliferation.',
                  'Necrosis - Areas of cell death within the tumor, which can appear as patchy or confluent zones.',
                  'Invasive Growth - Tumor invading into adjacent pancreatic tissue or vascular structures.',
                  'Perineural Invasion - Cancer cells seen surrounding or invading nerves, often associated with pain symptoms.',
                  'Lymphovascular Invasion - Presence of tumor cells within lymphatic or blood vessels, indicating potential for metastasis.',
                  'Micropapillary Features - Small papillary clusters without fibrovascular cores, often associated with aggressiveness.',
                  'Pseudopapillary Structures - Formation of delicate, fibrovascular stalks lined by neoplastic cells.',
                  'Acinar De-differentiation - Loss of normal acinar cell morphology and arrangement.',
                  'Lobular Atrophy - Atrophy of pancreatic lobules adjacent to or within the tumor.',
                  'Islet Cell Disruption - Disruption or invasion of pancreatic islets by tumor cells.',
                  'Inflammatory Infiltrate - Presence of lymphocytes, plasma cells, and occasionally neutrophils around or within the tumor.',
                  'Focal Anaplasia - Areas with undifferentiated tumor cells.',
                  'Cystic Changes - Presence of cystic areas within the tumor, varying in size.',
                  'Calcification - Deposition of calcium within the tumor tissue.',
                  'Fibrotic Encapsulation - Formation of a fibrotic capsule around the tumor mass.',
                  'Adipose Invasion - Invasion into surrounding fat tissue.'],
    'TCGA-KIRP': ['Anisokaryosis: Variation in nuclear size, which may indicate malignancy.',
                  'Hyperchromasia: Darkly stained nuclei suggesting DNA abundance, often seen in cancer cells.',
                  'Increased Nuclear-to-Cytoplasm Ratio: Common in cancer cells where nuclei occupy a larger proportion of the cell volume.',
                  'Prominent Nucleoli: Indicates increased protein synthesis, typical in cancer cells.',
                  'Mitotic Figures: Presence of cells in mitosis, indicative of rapid cell division.',
                  'Atypical Mitosis: Abnormal mitotic figures, which are common in malignant cells.',
                  'Dysplastic Cells: Cells with abnormal shape and organization, suggesting pre-cancerous changes.',
                  'Necrosis: Areas of cell death within the tissue, often seen in tumors due to poor blood supply.',
                  'Apoptotic Bodies: Small, round bodies indicative of programmed cell death.',
                  'Loss of Polarity: Disorganization in the arrangement of cells, typical in cancerous tissues.',
                  'Papillary Structures: Projections with fibrovascular cores, characteristic of papillary renal cell carcinoma.',
                  'Tubular Dilation: Enlargement of renal tubules, possibly due to obstructive processes.',
                  'Cyst Formation: Fluid-filled spaces which may be benign or malignant.',
                  'Fibrosis: Thickening and scarring of tissue, often as a response to chronic injury or inflammation.',
                  'Inflammatory Infiltrate: Presence of immune cells, which can indicate infection or autoimmune processes.',
                  'Interstitial Edema: Swelling between tissue cells, often from fluid accumulation.',
                  'Angiogenesis: Formation of new blood vessels, typically seen in growing tumors.',
                  'Stromal Reaction: Changes in the connective tissue surrounding tumors.',
                  'Hemorrhage: Presence of blood outside of blood vessels, can be an indicator of trauma or vascular injury.',
                  'Calcification: Deposition of calcium salts, which may occur in both benign and malignant conditions.'],
    'TCGA-HNSC': ['Squamous Cell Carcinoma - Malignant epithelial cells with keratinization and intercellular bridges.',
                  'Keratinizing Squamous Cell Carcinoma - Presence of keratin pearls and individual cell keratinization.',
                  'Non-keratinizing Squamous Cell Carcinoma - Lack of keratin production, usually more basophilic appearance.',
                  'Basaloid Squamous Cell Carcinoma - Highly aggressive variant characterized by small, basal-type cells and high nuclear-cytoplasmic ratio.',
                  'Verrucous Carcinoma - A variant of Squamous Cell Carcinoma with exophytic growth and minimal atypia.',
                  'Papillary Squamous Cell Carcinoma - Papillary structures with fibrovascular cores lined by atypical squamous cells.',
                  'Dysplasia - Abnormal growth and maturation of squamous epithelium, graded as mild, moderate, or severe.',
                  'Carcinoma In Situ - Full-thickness epithelial atypia without invasion through the basement membrane.',
                  'Microinvasive Squamous Cell Carcinoma - Early invasive carcinoma with minimal stromal invasion.',
                  'Lymphovascular Invasion - Tumor cells within lymphatic or blood vessels, indicating potential for metastasis.',
                  'Perineural Invasion - Tumor cells surrounding or invading nerve fibers.',
                  'Poorly Differentiated Carcinoma - Tumors with little to no squamous differentiation.',
                  'Moderately Differentiated Carcinoma - Tumors with some squamous features but significant atypia.',
                  'Well Differentiated Carcinoma - Tumors retaining many normal squamous features.',
                  'Inflammatory Response - Presence of inflammatory cells like lymphocytes and neutrophils within the tumor or surrounding tissue.',
                  'Necrosis - Areas of cell death within the tumor, often associated with hypoxia and rapid growth.',
                  'Stromal Reaction (Desmoplasia) - Fibrous tissue proliferation around the tumor.',
                  'Tumor Margins - Description of the edges of the tumor (pushing, infiltrative).',
                  'Hyperkeratosis - Thickening of the keratin layer on the surface of the epithelium.',
                  'Acanthosis - Thickening of the spinous layer of the epithelium.'],
    'TCGA-MESO': ['Pleomorphic Cells: Variably shaped and sized cells, indicating aggressive tumor behavior.',
                  'Nuclear Atypia: Abnormal nuclear morphology including enlarged nuclei, irregular shapes, and prominent nucleoli, suggestive of malignancy.',
                  'Mitotic Figures: High frequency of cells undergoing mitosis, indicative of rapid cell proliferation.',
                  'Psammoma Bodies: Laminated, calcified structures often seen in certain types of cancer, including mesothelioma.',
                  'Necrosis: Areas of cell death within the tissue, which may appear as regions of increased eosinophilia (pink staining).',
                  'Desmoplastic Reaction: Dense fibrous tissue formation around the tumor, often a response to invasive cancer.',
                  'Lymphocytic Infiltrates: Presence of lymphocytes within the tumor can suggest an immune response to the tumor.',
                  'Hyperchromasia: Darkly staining nuclei due to increased DNA content, typically seen in cancerous cells.',
                  'Biphasic Pattern: Presence of both epithelioid and sarcomatoid areas within the tumor, characteristic of biphasic mesothelioma.',
                  'Epithelioid Morphology: Predominantly epithelial-like cell appearance, often with more rounded and abundant cytoplasm.',
                  'Sarcomatoid Morphology: Spindle-shaped cells resembling fibrous tissue, indicating a more aggressive mesothelioma subtype.',
                  'Tubulopapillary Structures: Formation of tubular and papillary structures within the tumor, sometimes observed in epithelioid mesothelioma.',
                  'Stromal Invasion: Cancer cells invading into surrounding connective tissue, a hallmark of malignant behavior.',
                  'Clear Cell Features: Cells with clear, vacuolated cytoplasm, which can occasionally appear in mesothelioma.',
                  'Signet Ring Cells: Cells where the nucleus is pushed to one side by a large vacuole, rarely seen in mesothelioma.',
                  'Hobnail Appearance: Cells with a protruding surface, resembling a hobnail, sometimes observed in epithelial tumors.',
                  'Interstitial Fibrosis: Thickening of the interstitial spaces due to fibrous tissue deposition, indicative of tissue response or damage.',
                  'Vascular Invasion: Presence of tumor cells within blood vessels, suggesting potential for metastasis.',
                  'Pleural Effusion: Presence of excess fluid in pleural images may be indicative when associated histologically with disrupted mesothelial lining.',
                  'Calcifications: Mineral deposits within the tissue, which can be benign or associated with chronic irritation.'],
    'TCGA-TGCT': [
        'Seminoma: Uniform cells with clear cytoplasm and central nuclei, often accompanied by a lymphocytic infiltrate.',
        'Non-seminomatous germ cell tumor (NSGCT): Presence of heterogeneous cell populations different from seminoma.',
        'Embryonal carcinoma: Large, pleomorphic cells with prominent nucleoli and frequent mitotic figures.',
        'Yolk sac tumor (endodermal sinus tumor): Schiller-Duval bodies (glomeruloid structures), and lace-like reticular patterns.',
        'Choriocarcinoma: Hemorrhage and necrosis, with biphasic population of cytotrophoblasts and syncytiotrophoblasts.',
        'Teratoma: Presence of elements from multiple germ layers (e.g., epithelial, mesenchymal, and neural tissues).',
        'Leydig cell tumor: Large eosinophilic cells with abundant granular cytoplasm, often with Reinke crystals.',
        'Sertoli cell tumor: Trabecular or tubular architecture with uniform cells having nongranular cytoplasm.',
        'Mixed germ cell tumor: Combinations of two or more types of GCT histologies.',
        'Intratubular germ cell neoplasia, unclassified (IGCNU): Large cells with clear cytoplasm and atypical nuclei lining the seminiferous tubules.',
        'Lymphocytic infiltration: Common in seminomas, suggestive of immune response.',
        'Vascular invasion: Presence of tumor cells within blood vessels, indicative of aggressive behavior.',
        'Necrosis: Areas of cell death, which can indicate high tumor grade.',
        'Fibrosis: Scar tissue formation, potentially indicating regressed tumor or treatment effect.',
        'Calcification: Deposition of calcium salts, sometimes seen in burned-out tumors.',
        'Hyalinization: Homogeneous eosinophilic deposits in the stroma or around tubules, often seen in aging testes.',
        'Cryptorchidism related changes: Histological alterations associated with undescended testes, such as decreased spermatogenesis.',
        'Inflammation: Acute or chronic inflammatory cells, which may suggest infection or autoimmune response.',
        'Granulomatous reaction: Formation of granulomas around spermatogenic cells or foreign material.',
        'Spermatocytic tumor: Presence of cells resembling spermatocytes, typically less aggressive.'],
    'TCGA-UCS': ['Atypical Glandular Hyperplasia: Precancerous changes with irregular glandular proliferation',
                 'Endometrial Hyperplasia: Thickening of the endometrium, can be simple or complex, with or without atypia',
                 'Endometrial Polyp: Benign overgrowths of the endometrial lining that may display abnormal architecture or cellular changes',
                 'Endometrial Intraepithelial Neoplasia (EIN): A precancerous condition characterized by crowded glands with cytological atypia',
                 'Endometrial Carcinoma: Malignant glands showing varying degrees of differentiation, often invasive',
                 'Squamous Metaplasia: Benign squamous cells in the endometrium, which can be a reactive process or associated with chronic irritation',
                 'Endometritis: Inflammatory cells infiltrating the endometrial stroma, indicative of infection or chronic inflammation',
                 'Adenomyosis: Presence of endometrial tissue within the myometrium causing glandular distortion and stromal fibrosis',
                 'Leiomyoma (Fibroid): Benign smooth muscle tumors with well-demarcated borders and whorled pattern',
                 'Leiomyosarcoma: Malignant smooth muscle tumor with atypical cells and increased mitotic activity',
                 'Carcinosarcoma (Malignant Mixed Müllerian Tumor): Contains both carcinomatous and sarcomatous components',
                 'Stromal Sarcoma: Malignant stromal proliferation with possible heterologous elements',
                 'Endometrial Stromal Sarcoma: Low-grade malignant stromal tumor with uniform cells infiltrating the myometrium',
                 'Serous Carcinoma: High-grade carcinoma with papillary structures and severe nuclear atypia',
                 'Clear Cell Carcinoma: Contains clear cells with a glycogen-rich cytoplasm, forming tubular or papillary structures',
                 'Mucinous Carcinoma: Mucin-producing cells forming glands or cysts, often with atypical nuclei',
                 'Lymphocytic Infiltrate: Dense lymphocytic infiltrations, potentially indicating an immune response or lymphoma',
                 'Arteriolosclerosis: Thickening of the walls of small arteries, often related to hypertension or aging',
                 'Venous Thrombosis: Blood clots within a venous structure, potentially leading to complications if not identified',
                 'Necrosis: Areas of cell death, which may indicate aggressive tumor growth or ischemia'],
    'TCGA-THYM': [
        'Lymphocytic Infiltration - Dense infiltration of lymphocytes indicating an immune response or autoimmune conditions.',
        'Thymic Hyperplasia - Expansion of thymic tissue, potentially true hyperplasia or lymphoid hyperplasia associated with myasthenia gravis.',
        'Thymic Atrophy - Reduction in thymic size and cellularity, commonly seen in aging or stress.',
        'Thymoma - Neoplastic growth characterized by lobulated architecture and a mixture of lymphocytes and epithelial cells.',
        'Cyst Formation - Presence of cysts which can be congenital or acquired.',
        'Follicular Hyperplasia - Increased number of lymphoid follicles, often linked to autoimmune disorders.',
        'Thymic Carcinoma - Malignant epithelial tumor with cytological atypia and invasive growth.',
        'Hassall’s Corpuscles Alteration - Changes in the size and number of Hassall’s corpuscles in the medulla.',
        'Necrosis - Areas of cell death indicating aggressive tumor growth or ischemia.',
        'Calcifications - Deposition of calcium salts, typically dystrophic.',
        'Fibrosis - Increase in fibrous tissue suggesting chronic damage or healing.',
        'Hemosiderin Deposition - Deposits of iron storage complexes following hemorrhage.',
        'Lymphocyte Depletion - Loss of lymphocytes suggesting immunodeficiency or high-grade malignancy.',
        'Inflammatory Infiltrates - Presence of inflammatory cells like neutrophils, eosinophils, or plasma cells.',
        'Squamous Metaplasia - Transformation of normal epithelial cells into squamous cells, usually seen in inflammatory conditions.',
        'Lipomatosis - Replacement of thymic tissue with adipose tissue, often related to aging.',
        'Oncoytic Changes - Presence of oncocytic cells, epithelial cells with abundant mitochondria, indicative of degenerative changes.',
        'Vascular Changes - Alterations in blood vessels such as vessel wall thickening or increased vasculature.',
        'Amyloid Deposition - Deposition of amyloid proteins affecting organ function.',
        'Granuloma Formation - Formation of granulomas in chronic inflammatory responses.'],
    'TCGA-SKCM': ['Atypical Melanocytes - Irregularly shaped melanocytes that may form nests or be dispersed singly',
                  'Nuclear Pleomorphism - Variability in the size and shape of nuclei within melanocytes, often a hallmark of malignancy',
                  'Increased Nucleocytoplasmic Ratio - Larger nuclei in cells compared to the amount of cytoplasm',
                  'Prominent Nucleoli - Enlarged nucleoli within nuclei, which can be a sign of active cellular proliferation',
                  'Mitotic Figures - Presence of cells undergoing division, indicating high cellular turnover',
                  'Pagetoid Spread - Atypical melanocytes spreading upwards into the epidermis',
                  'Ulceration - Breakdown of the overlying epidermis above a tumor',
                  'Vertical Growth Phase - Tumor cells penetrating deeper into the dermis, as opposed to horizontal spread',
                  'Regression Areas - Areas where the tumor cells are dying off, often replaced by fibrosis and inflammation',
                  'Solar Elastosis - Accumulation of abnormal elastic fibers in the dermis due to sun damage, often found surrounding melanoma',
                  'Angiotropism - Tumor cells lining up along blood vessels, potentially indicative of a route for metastasis',
                  'Tumor-Infiltrating Lymphocytes - Presence of lymphocytes within the tumor, can be a sign of the immune system responding to the tumor',
                  'Perineural Invasion - Tumor cells found surrounding or invading nerves',
                  'Desmoplastic Reaction - Dense fibrous tissue formation in response to the tumor',
                  'Microsatellitosis - Small nests of melanoma cells found separate from the primary tumor mass',
                  'Neurotropism - Tumor cells showing affinity for nerve structures',
                  'Lentiginous Proliferation - Linear growth of atypical melanocytes along the epidermal basal layer',
                  'Melanophages - Macrophages that have ingested melanin, indicating areas of previous melanocytic activity',
                  'Melanin Pigment - Presence of dark pigment within cells or extracellularly, can complicate the histological evaluation',
                  'Atypical Dermal Fibroplasia - Abnormal growth of fibrous tissue in the dermis, which may accompany invasive melanoma'],
    'TCGA-KICH': [
        'Pale Cytoplasm: Characterized by pale or clear cytoplasm due to fine, reticular cytoplasmic halos typical in chromophobe RCC.',
        'Perinuclear Halos: Clear zones around the nucleus, typical in chromophobe RCC.',
        'Raisinoid Nuclei: Irregular nuclear contours resembling raisins, a characteristic feature of chromophobe RCC.',
        'Nuclear Wrinkling: Wrinkled or irregular nuclear membrane.',
        'Binucleation and Multinucleation: Presence of cells with more than one nucleus.',
        'Hyperchromasia: Intense nuclear staining, indicative of increased DNA content.',
        'Prominent Nucleoli: Visible nucleoli in some cells, a sign of cellular activity.',
        'Acidophilic Cytoplasm: Eosinophilic (pinkish) cytoplasm in certain areas.',
        'Sheet-like Architecture: Formation of sheets of cells with minimal intervening stroma in chromophobe RCC.',
        'Fibrous Stroma: Dense fibrous connective tissue potentially indicating a desmoplastic reaction.',
        'Microcystic Structures: Small cyst-like spaces within the tumor mass.',
        'Calcifications: Mineral deposits within the tissue, visible as dark, dense areas in slides.',
        'Vascular Invasion: Presence of tumor cells within blood vessels, indicating aggressive behavior.',
        'Inflammatory Infiltrates: Presence of immune cells within or around the tumor, suggesting an immune response.',
        'Necrosis: Dead cells appearing as eosinophilic (pink) and structureless regions.',
        'Hyaline Globules: Eosinophilic round inclusions within cells or extracellularly.',
        'Spindle Cell Areas: Regions where cells have spindle-shaped morphology, seen in sarcomatoid differentiation.',
        'Clear Cells: Regions with cells having clear cytoplasm, needing differentiation from clear cell RCC.',
        'Papillary Structures: Formation of finger-like projections within the tumor, less common in chromophobe RCC.',
        'Adipose Metaplasia: Replacement of normal kidney tissue with fatty tissue.'],
    'TCGA-ACC': ['Cellular Pleomorphism - Variability in cell size and shape, which can indicate malignancy.',
                 'Nuclear Atypia - Abnormal nuclear size, shape, or staining indicating cellular abnormalities.',
                 'High Nuclear-to-Cytoplasmic Ratio - More nucleus than cytoplasm, often seen in cancer cells.',
                 'Prominent Nucleoli - Visible nucleoli within the nucleus, typically associated with active protein synthesis in malignant cells.',
                 'Increased Mitotic Activity - Higher than normal numbers of cells undergoing mitosis, indicative of rapid cell division.',
                 'Loss of Normal Adrenal Architecture - Disruption in the regular structure of the adrenal gland.',
                 'Necrosis - Areas of cell death within the tissue, which can indicate aggressive tumor growth.',
                 'Capsular Invasion - Tumor cells breaking through the adrenal gland’s capsule, suggesting an invasive cancer.',
                 'Vascular Invasion - Presence of cancer cells within blood vessels, indicating potential for metastasis.',
                 'Fibrous Bands - Increased fibrosis within the gland, often seen in chronic conditions.',
                 'Lipid Depletion - Loss of intracellular lipid droplets in adrenal cortical cells, potentially indicative of a functional tumor.',
                 'Hyalinization - Accumulation of homogenous, glassy material in the stroma, typical in both benign and malignant conditions.',
                 'Calcifications - Deposits of calcium salts, sometimes associated with old hemorrhage or necrosis.',
                 'Cystic Changes - Formation of cysts within the gland, which may be benign or part of a tumor.',
                 'Inflammatory Infiltrate - Presence of immune cells, which can indicate an immune response to tumors or infection.',
                 'Adrenal Cortical Hyperplasia - Increase in the number of cells in the cortex, possibly a precursor to tumor development.',
                 'Adrenal Medullary Hyperplasia - Increase in the number of cells in the medulla, which may be reactive or part of a systemic condition.',
                 'Oncocytic Changes - Cells with abundant, granular, eosinophilic cytoplasm, indicative of mitochondrial accumulation.',
                 'Melanin Pigmentation - Unusual in the adrenal gland, could be indicative of metastatic melanoma.',
                 'Myelolipoma - Presence of mature adipose and myeloid tissue, a benign but notable finding.'],
    'TCGA-CHOL': [
        'Atypical Bile Duct Epithelium: Dysplastic cells with large, hyperchromatic nuclei and irregular shapes, indicating pre-cancerous changes.',
        'Increased Nuclear-to-Cytoplasmic Ratio: Cells where the nucleus occupies more space relative to the cytoplasm, a common feature in cancer cells.',
        'Pleomorphism: Variation in size and shape of cells, often seen in malignancies.',
        'Mitotic Figures: High number of cells undergoing mitosis, suggestive of rapid cell division typical in cancer.',
        'Necrosis: Areas of cell death, which can be extensive in aggressive tumors.',
        'Inflammatory Infiltrate: Presence of inflammatory cells, which can be reactive or associated with tumor invasion.',
        'Perineural Invasion: Cancer cells seen invading nerves in the bile duct wall, a poor prognostic indicator.',
        'Angiolymphatic Invasion: Tumor cells within blood or lymphatic vessels, suggesting potential for metastasis.',
        'Fibrosis: Thickening and scarring of tissue, often as a response to chronic injury or inflammation.',
        'Mucinous Features: Tumors producing excessive mucin, which can alter the tumor environment.',
        'Clear Cell Changes: Cells with clear cytoplasm, which may indicate metabolic alterations.',
        'Granular Cell Changes: Cells with a granular cytoplasm, possibly due to abnormal cellular metabolism.',
        'Bile Stasis: Accumulation of bile in ducts, often due to obstruction.',
        'Cholestasis: Impaired bile flow which can be reactive or indicative of liver dysfunction.',
        'Portal Tract Expansion: Enlargement of the portal areas in the liver, typically due to inflammation or fibrosis.',
        'Lobular Disarray: Disruption in the normal architecture of the liver lobules.',
        'Steatosis: Fatty changes in liver cells, which can be due to various metabolic conditions.',
        'Bile Ductular Reaction: Proliferation of bile ductules often in response to severe liver injury or biliary diseases.',
        'Gland Formation: Abnormal formation of gland-like structures within the tumor, characteristic of adenocarcinoma.',
        'Desmoplastic Reaction: Dense fibrotic tissue response around a tumor, commonly seen in invasive cancers.'],
    'TCGA-DLBC': ['Increased Cellularity: High density of cells suggesting lymphoid hyperplasia or lymphoma.',
                  'Atypical Lymphocytes: Irregularly shaped lymphocytes with abnormal nuclei indicating potential lymphoproliferative disorders.',
                  'Loss of Architecture: Disruption of the normal architecture of lymphoid tissues can be a sign of malignancy.',
                  'Germinal Center Expansion: Enlarged germinal centers may indicate reactive hyperplasia or follicular lymphoma.',
                  'Necrosis: Areas of tissue death, potentially indicating aggressive disease.',
                  'Mitotic Figures: High numbers of dividing cells, suggestive of high cellular turnover as seen in malignancies.',
                  "Reed-Sternberg Cells: Presence of these cells is indicative of Hodgkin's lymphoma.",
                  'Starry Sky Pattern: Presence of scattered tingible body macrophages among proliferating cells, often seen in Burkitt lymphoma.',
                  'Plasmacytosis: Increase in plasma cells, which may suggest chronic inflammation or plasma cell neoplasia.',
                  'Granulomas: Formation of granulomas can indicate chronic inflammatory disorders, infections, or sarcoidosis.',
                  'Monocytoid B Cells: Suggestive of a reaction to chronic inflammation or certain types of lymphoma.',
                  'Angioimmunoblastic T-Cell Proliferation: A pattern suggestive of angioimmunoblastic T-cell lymphoma.',
                  'Epithelioid Cells: These can indicate granulomatous disease or Hodgkin lymphoma.',
                  'Lymphoepithelial Lesions: Association with lymphomas or Sjögren’s syndrome.',
                  'Follicular Dendritic Cell Sarcoma: Abnormal proliferation of follicular dendritic cells.',
                  'Karyorrhexis: Nuclear debris as a result of cell death, often seen in necrotic areas.',
                  'Russell Bodies: Accumulation of immunoglobulin in plasma cells, indicative of chronic inflammation or plasma cell dyscrasia.',
                  'Fibrosis: Thickening and scarring of tissue, often indicating chronic damage or transformation.',
                  'Vascular Proliferation: Increased formation of blood vessels, sometimes associated with high-grade lymphomas.',
                  'Castleman’s Disease Features: Lymph node hyperplasia that can resemble lymphoma.']}
