# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Custom type annotations."""
import pathlib
from typing import Any, Callable, Tuple, Text, Union

PRNGKey = Any
Shape = Tuple[int]
Dtype = Any  # this could be a real type?
Array = Any

Activation = Callable[[Array], Array]
Initializer = Callable[[PRNGKey, Shape, Dtype], Array]
Normalizer = Callable[[], Callable[[Array], Array]]

PathType = Union[Text, pathlib.PurePosixPath]

RENDER_MODE = {
    'regular': 0,
    'static': 1,
    'static_only': 2,
    'dynamic': 3,
    'dynamic_only': 4,
    'blendw': 5,
    'deformation': 6,
    'time': 7
}
