from typing import Tuple, Dict
import numpy as np
from patching_gemma import logger

def simple_save_imp_scores(importance_scores, log_dir, num_requests) -> None:
    log_dir.mkdir(parents=True, exist_ok=True)
    importance_scores = importance_scores / num_requests
    np.save(log_dir.joinpath("attn_scores.npy"), importance_scores.numpy())
    logger.info(f"Saved 1 file to {str(log_dir)}")