import numpy as np
from .base_cam import BaseCAM


class get_feature_map(BaseCAM):
    def __init__(self, model, target_layers, use_cuda=False,
                 reshape_transform=None, device="cuda:0"):
        super(
            get_feature_map,
            self).__init__(
            model,
            target_layers,
            use_cuda,
            reshape_transform,
            device = device)

    def get_cam_weights(self,
                        input_tensor,
                        target_layer,
                        target_category,
                        activations,
                        grads):
        return np.mean(grads, axis=(2, 3))

