# FairPATE

## Usage
```bash
usage: fairpate.py [-h] [--dataset DATASET]
                   [--list_dataset LIST_DATASET [LIST_DATASET ...]]
                   [--num_classes NUM_CLASSES]
                   [--output_col_name OUTPUT_COL_NAME] [--split SPLIT]
                   [--fairness_metric FAIRNESS_METRIC]
                   [--list_fairness_metric LIST_FAIRNESS_METRIC [LIST_FAIRNESS_METRIC ...]]
                   [--dem_disparity_interpretation DEM_DISPARITY_INTERPRETATION]
                   [--teacher_query_set_split TEACHER_QUERY_SET_SPLIT]
                   [--num_teachers NUM_TEACHERS]
                   [--list_num_teachers LIST_NUM_TEACHERS [LIST_NUM_TEACHERS ...]]
                   [--threshold THRESHOLD]
                   [--list_threshold LIST_THRESHOLD [LIST_THRESHOLD ...]]
                   [--fairness_threshold FAIRNESS_THRESHOLD]
                   [--list_fairness_threshold LIST_FAIRNESS_THRESHOLD [LIST_FAIRNESS_THRESHOLD ...]]
                   [--sigma_threshold SIGMA_THRESHOLD]
                   [--list_sigma_threshold LIST_SIGMA_THRESHOLD [LIST_SIGMA_THRESHOLD ...]]
                   [--sigma_fair_threshold SIGMA_FAIR_THRESHOLD]
                   [--sigma_gnmax SIGMA_GNMAX]
                   [--list_sigma_gnmax LIST_SIGMA_GNMAX [LIST_SIGMA_GNMAX ...]]
                   [--budget BUDGET]
                   [--list_budget LIST_BUDGET [LIST_BUDGET ...]]
                   [--delta DELTA] [--verbose] [--seed SEED]
                   [--list_seed LIST_SEED [LIST_SEED ...]]
                   [--data_path DATA_PATH] [--min_group_count MIN_GROUP_COUNT]
                   [--results_dir RESULTS_DIR] [--use_optuna]
                   [--use_stratification]

optional arguments:
  -h, --help            show this help message and exit
  --dataset DATASET
  --list_dataset LIST_DATASET [LIST_DATASET ...]
                        A list of datasets to run the experiment on.
  --num_classes NUM_CLASSES
  --output_col_name OUTPUT_COL_NAME
  --split SPLIT
  --fairness_metric FAIRNESS_METRIC
  --list_fairness_metric LIST_FAIRNESS_METRIC [LIST_FAIRNESS_METRIC ...]
                        A list of fairness metrics to run the experiment on.
  --dem_disparity_interpretation DEM_DISPARITY_INTERPRETATION
  --teacher_query_set_split TEACHER_QUERY_SET_SPLIT
  --num_teachers NUM_TEACHERS
  --list_num_teachers LIST_NUM_TEACHERS [LIST_NUM_TEACHERS ...]
                        A list of number of teachers to run the experiment on.
  --threshold THRESHOLD
  --list_threshold LIST_THRESHOLD [LIST_THRESHOLD ...]
                        A list of thresholds to run the experiment on.
  --fairness_threshold FAIRNESS_THRESHOLD
  --list_fairness_threshold LIST_FAIRNESS_THRESHOLD [LIST_FAIRNESS_THRESHOLD ...]
                        A list of fairness thresholds to run the experiment
                        on.
  --sigma_threshold SIGMA_THRESHOLD
  --list_sigma_threshold LIST_SIGMA_THRESHOLD [LIST_SIGMA_THRESHOLD ...]
                        A list of sigma thresholds to run the experiment on.
  --sigma_fair_threshold SIGMA_FAIR_THRESHOLD
  --sigma_gnmax SIGMA_GNMAX
  --list_sigma_gnmax LIST_SIGMA_GNMAX [LIST_SIGMA_GNMAX ...]
                        A list of sigma gnmax to run the experiment on.
  --budget BUDGET
  --list_budget LIST_BUDGET [LIST_BUDGET ...]
                        A list of budgets to run the experiment on.
  --delta DELTA
  --verbose
  --seed SEED
  --list_seed LIST_SEED [LIST_SEED ...]
                        A list of seeds to run the experiment on.
  --data_path DATA_PATH
  --min_group_count MIN_GROUP_COUNT
  --results_dir RESULTS_DIR
                        Directory to store the results in.
  --use_optuna          Whether to use optuna to find the best
                        hyperparameters.
  --use_stratification  Whether to use stratification to split the data.
```


### Grid Search Example
```bash
PYTHONPATH="." python fairpate_tabular/fairpate.py --list_num_teachers 25 30 35 --list_threshold 2 3 4 5 --list_sigma_threshold 1 2 3 --sigma_gnmax 8 --list_budget 3 4 5 6 7 8 9 10 --fairness_threshold 0.02 --dataset retired-adult
```


## Acknowledgement
Dataloader class and scripts from [https://arxiv.org/abs/2210.08781](https://arxiv.org/abs/2210.08781)