from tkinter import *


class ToolTip(object):
    def __init__(self, widget):
        self.widget = widget
        self.tipwindow = None
        self.id = None
        self.x = self.y = 0

    def showtip(self, text):
        "Display text in tooltip window"
        self.text = text
        if self.tipwindow or not self.text:
            return
        x, y, cx, cy = self.widget.bbox("insert")
        x = x + self.widget.winfo_rootx() + 57
        y = y + cy + self.widget.winfo_rooty() + 27
        self.tipwindow = tw = Toplevel(self.widget)
        tw.wm_overrideredirect(1)
        tw.wm_geometry("+%d+%d" % (x, y))
        label = Label(
            tw,
            text=self.text,
            justify=LEFT,
            background="#ffffe0",
            foreground="#000",
            relief=SOLID,
            borderwidth=1,
        )
        label.config(font=("Arial", 10))
        label.pack(ipadx=1)

    def hidetip(self):
        tw = self.tipwindow
        self.tipwindow = None
        if tw:
            tw.destroy()


def add_tooltip(widget, text, max_length=45):
    """Add a small tooltip window to a widget."""
    if text:
        toolTip = ToolTip(widget)

        def enter(event):
            toolTip.showtip(cut_text(text, max_length))

        def leave(event):
            toolTip.hidetip()

        widget.bind("<Enter>", enter)
        widget.bind("<Leave>", leave)


def cut_text(text, max_length):
    """Cut a string at about 'max_length' chars into multiple lines."""
    words = text.split(" ")
    new_text = ""
    line_lenght = 0
    for word in words:

        # If specific linebreak is given, reset length count and continue
        if "\n" in word:
            line_lenght = 0
            new_text += word + " "
            continue

        if line_lenght + len(word) > max_length:
            line_lenght = 0
            new_text += "\n"
        new_text += word + " "
        line_lenght += len(word)
    return new_text


def entry_to_json(entry):
    """Convert an entry to a dictionary object."""
    json_dict = {}
    json_dict["color"] = entry.color
    json_dict["label"] = entry.label
    json_dict["inner_level"] = vars(entry.inner_level)
    json_dict["outer_level"] = vars(entry.outer_level)
    return json_dict

def scale_image_to_width(image, width):
    from PIL import Image
    old_width, old_height = image.size
    scale = width / old_width
    image_height = int(old_height * scale)
    image = image.resize(size=(width, image_height), resample=Image.ANTIALIAS)
    return image
