# CauFed-CLIP: Causal Federated Vision-Language Models for Domain Generalization


<p align="center">
<img src="./Pipeline.png" alt="intro" width="90%"/>
</p>


## Requirements

We suggest you to use the following packages:

clip==1.0

numpy==2.3.2

Pillow==11.3.0

scikit_learn==1.7.1

scipy==1.16.1

torch==2.1.2

torchvision==0.16.2

tqdm==4.67.1

## How to use

### main.py 

Run main.py to reproduce our results.

```sh
python -u main.py --method ours --lr 0.00005 --clr 0.00005 --dataset PACS
 --iters 50 --use_clipz --use_clips --test_envs 2 3
```

### nets/models.py

models.py is the model backbone file.

### utils/clip_util.py

clip_util.py is the utils that CLIP will use. For FedAVG, MOON and FedProx, you have to do the following steps:

For FAA-CLIP and FedCLIP, you have to set it as False.

### utils/prepare_data_dg_clip.py

prepare_data_dg_clip.py is the dataloader CLIP will use. You can define the percentage for training, val and test via:
```sh
l1, l2, l3 = int(l*0.8), int(l*0.1), int(l*0.1)
```

### utils/training.py

training.py is the training function for ours method.

## dataset


