# Example

```bash
accelerate launch --num_processes 4 --gpu_ids 4,5,6,7 eval_llada.py --tasks ${task} --num_fewshot ${num_fewshot} --limit ${ratio} \
--confirm_run_unsafe_code --model llada_dist \
--model_args model_path=${model_path},gen_length=${length},draft_length=${draft_length},steps=${length},block_length=${block_length},show_speed=${show_speed},ssd=${ssd},verbose=${verbose},kv_cache=${kv_cache}
```
# Arguments
## Accelerate
```bash
--num_processes 4
--gpu_ids 4,5,6,7
```
## lm_eval
```bash
--tasks ${task}
--num_fewshot ${num_fewshot}
--limit ${ratio} """完整数据集使用的比例"""
--output_path 
--log_samples
```
## LLaDA Decode
```bash
model_path """模型路径"""
gen_length """生成长度"""
draft_length """草稿容量"""
steps """解码步数"""
block_length """块长度"""
show_speed """是否显示速度"""
ssd """是否使用SSD"""
verbose """是否显示详细信息"""
kv_cache """是否使用kv cache"""
```

# Ablation
## Vanilla
```bash
kv_cache=False
ssd=False
show_speed=True
verbose=False
```
## Vanilla+Dual Cache
```bash
kv_cache=True
ssd=False
show_speed=True
verbose=False
```
## SSD+Dual Cache
```bash
kv_cache=True
ssd=True
show_speed=True
verbose=False
```