# Self Cascaded Speculative Decoding for DLLMs


## Directory Structure

- `eval_model/`: LLaDA model's lm_eval interface implementation
- `utils/`: Generation functions and utility functions
- `scripts/`: Evaluation scripts
- `LLaDA-8B-Instruct-length-analysis/`: Model files (symbolic link)

## Supported Tasks

### Mathematics and Reasoning
- **GSM8K**: Elementary math problem solving
  ```bash
  bash scripts/run_LLaDA_gsm8k_Instruct.sh
  ```

- **Minerva Math**: Advanced mathematical reasoning
  ```bash
  bash scripts/run_LLaDA_minerva_math_Instruct.sh
  ```

### Programming Tasks
- **HumanEval**: Python code generation
  ```bash
  bash scripts/run_LLaDA_humaneval_Instruct.sh
  ```

- **MBPP**: Basic Python programming problems
  ```bash
  bash scripts/run_LLaDA_mbpp_Instruct.sh
  ```

### Multi-task Understanding
- **MMLU Generative**: Multi-domain knowledge testing
  ```bash
  bash scripts/run_LLaDA_mmlu_generative_Instruct.sh
  ```

- **MMLU Pro**: Advanced multi-task understanding
  ```bash
  bash scripts/run_LLaDA_mmlu_pro_Instruct.sh
  ```

### Complex Reasoning
- **BBH (BIG-Bench Hard)**: Challenging reasoning tasks
  ```bash
  bash scripts/run_LLaDA_bbh_Instruct.sh
  ```

- **GPQA**: Graduate-level physics Q&A
  ```bash
  bash scripts/run_LLaDA_gpqa_Instruct.sh
  ```

### Long Text Understanding
- **LongBench**: Long text comprehension tasks
  ```bash
  bash scripts/run_LLaDA_long_bench_Instruct.sh
  ```

## Usage

1. Ensure required dependencies are installed:
   ```bash
   pip install lm-eval transformers accelerate datasets
   ```

2. Navigate to the minimal directory:
   ```bash
   cd minimal
   ```

3. Run any evaluation script:
   ```bash
   bash scripts/run_LLaDA_[task_name]_Instruct.sh
   ```

## Task Parameter Configuration

Different tasks use different generation parameters:

- **General tasks** (BBH, MMLU, etc.): `block_length=256, gen_length=256, steps=256`
- **Code generation** (HumanEval, MBPP): `block_length=32, gen_length=512, steps=512`
- **Math tasks** (GSM8K): `block_length=8, gen_length=256, steps=256`
- **Long text** (LongBench): `block_length=32, gen_length=32, steps=32`
- **Physics Q&A** (GPQA): `block_length=64, gen_length=128, steps=128`

## Important Notes

1. This version has all caching functionality removed
2. Only LLaDA model support is retained (Dream and MMaDA removed)
3. The entire minimal directory can be moved to other locations for independent use
4. Code generation tasks (HumanEval, MBPP) require the `--confirm_run_unsafe_code` parameter
5. All scripts default to 8-GPU parallel execution (configured via accelerate_config.yaml)