import pointnet2_utils as futils
import os
import trimesh
import numpy as np
import torch
train_list = "../../../../ModelNet_mesh_dataset/airplane/test"
save_train_list = "../../../../ModelNet_mesh_dataset/airplane/test_fps_gt"
if not os.path.isdir(save_train_list):
    os.mkdir(save_train_list)
file_lst = [os.path.join(train_list, i)  for i in os.listdir(train_list) if 'annot' not in i]
save_lst = [os.path.join(save_train_list, i[:-4])  for i in os.listdir(train_list) if 'annot' not in i]
torch.cuda.set_device(0)
for i in range(len(file_lst)):
    m = trimesh.load(file_lst[i])
    pc,_ = trimesh.sample.sample_surface(m, 4096)
    idx = futils.furthest_point_sample(torch.Tensor(pc).unsqueeze(0).cuda(), 1024).cpu().numpy()
    np.save(save_lst[i], pc[idx][0])
    print(i)