import tensorboardX
from datetime import date
import configparser

class Parameters():
    def __init__(self):     
        super(Parameters, self).__init__()
   
        
    def read_config(self, fn):
        config = configparser.ConfigParser()
        config.read(fn)
        print(fn)        
        self.read_weight_path = config.get("Record","read_weight_path")
        self.write_weight_folder=config.get("Record","write_weight_folder")
        logdir = config.get("Record","logdir")
        self.logger = tensorboardX.SummaryWriter(logdir)
        self.dataset = config.get("Record", "dataset")
        
        self.lr =float( config.get("Params", "lr"))
        
        self.start_iteration=int(config.get("Params","start_iteration"))
        self.total_iteration=int( config.get("Params", "total_iteration"))
        self.save_weight_iteration=int( config.get("Params", "save_weight_iteration"))
        
        self.out_rotation_mode = config.get("Params","out_rotation_mode")
        self.model_kind = int(config.get("Params", "model_kind"))
        #self.weight_pose=float( config.get("Params", "weight_pose"))
        self.weight_rmat=float( config.get("Params", "weight_rmat"))
        self.weight_mean = float(config.get("Params", "weight_mean"))
        #self.weight_geodesic=float( config.get("Params", "weight_geodesic"))
        self.manifold = float(config.get("Params", "manifold"))

        self.regress_t = int(config.get("Params", "regress_t"))
        self.sample_num = int(config.get("Params", "sample_num"))
        self.device = int(config.get("Params","device"))
        self.supervision = config.get("Params","supervision")
        self.batch = int (config.get("Params","batch"))
        
        #self.global_motion = bool(int( config.get("Params", "global_motion")))
        
        
        self.data_folder =config.get("Record", "data_folder")

                
        
        







































