# Project Structure

```bash
project_root/
├── src/                   # Source code directory
│   ├── __init__.py        # Makes src a Python package
│   ├── cpro.py            # CPRO environment implementation
│   ├── model.py           # RNN model definition
│   ├── train.py           # Training and evaluation functions
│   ├── utils.py           # General utilities
│   ├── plot_utils.py      # Visualization utilities
│   ├── stats_utils.py     # Stats utilities
│   └── analysis_utils.py  # General analysis utilities
│
├── notebooks/             # Jupyter notebooks directory
│   ├── general_plotting_notebook.ipynb # Main training evaluation notebook
│   └── stim_hidden_activities.ipynb    # Main hidden unit analyses notebook
│
├── results/               # Results directory (git-ignored)
│   └── experiment_*/      # Timestamped experiment results
│
├── scripts/               # Scripts, executed in terminal (git-ignored)
│   ├── run_scale_experiment.py      # Individual experiment script
│   ├── slurm_batch_cpu.py           # Parallel experiment management
│   ├── compute_dimensionalities.py  # Dimensionality computation in parallel
│   ├── gen_acc_dim_regression.py    # Generalization accuracy - Dimensionality regressions
│   └── theoretical_rsm.py           # Theoretical RSMs based on features for dimensionality intuition
│
└── PROJECT_STRUCTURE.md   # This file