# __init__.py

from .cpro import CPRO, CPROConfig
from .model import RankControlledRNN
from .train import train_epoch, evaluate, run_rank_experiment
from .visualization import (
    plot_rank_comparison,
    plot_overlap_comparison,
    plot_rank_error_analysis,
    plot_probability_confusion,
    plot_training_diagnostics
)

__all__ = [
    # Environment
    'CPRO',
    'CPROConfig',
    
    # Model
    'RankControlledRNN',
    
    # Training
    'train_epoch',
    'evaluate',
    'run_rank_experiment',
    
    # Visualization
    'plot_rank_comparison',
    'plot_overlap_comparison',
    'plot_rank_error_analysis',
    'plot_probability_confusion',
    'plot_training_diagnostics'
]