# paths to precomputed embeddings
embeddings_main_path = {
    'DomainNet': './data/embeddings/DomainNet',
    'FMoW': './data/embeddings/FMoW',
    'COCOShift_balanced': './data/embeddings/COCOShift',
    'COCOShift75': './data/embeddings/COCOShift',
    'COCOShift90': './data/embeddings/COCOShift',
    'COCOShift95': './data/embeddings/COCOShift'
}

# paths to dataset splits
metadata_main_path = {
    'DomainNet': './data/splits/DomainNet/DomainNet.pkl',
    'FMoW': './data/splits/FMoW/FMoW.pkl',
    'COCOShift_balanced': './data/splits/COCOShift/COCOShift_balanced.pkl',
    'COCOShift75': './data/splits/COCOShift/COCOShift75.pkl',
    'COCOShift90': './data/splits/COCOShift/COCOShift90.pkl',
    'COCOShift95': './data/splits/COCOShift/COCOShift95.pkl'
}

# available datasets
DATASETS = ['COCOShift_balanced', 'COCOShift75',
            'COCOShift90', 'COCOShift95', 'DomainNet', 'FMoW']

# available features
FEATURES_TYPES = ['resnet18', 'resnet34', 'clip', 'align', 'blip2']

# available features selection methods
RANKING_METHODS = ['random',
                   'PCA_loadings', 'InfoGain', 'FisherScore', 'MAD', 'Dispersion', 'Variance',
                   'Stylist']

# available novelty detection algorithms
ND_METHODS = ['kNN']

# baseline feature selection methods that consider style information
env_aware_baselines = ['InfoGain', 'FisherScore']

# selection method for which we apply standardization before ranking
STANDARDIZE_BEFORE_RANKING = {
    'random': 0,
    'PCA_loadings': 1,
    'InfoGain': 0,
    'FisherScore': 0,
    'MAD': 0,
    'Dispersion': 1,
    'Variance': 0,
    'Stylist': 0
}

# environments per dataset
id_ood_envs = {
    'DomainNet': {
        'id_envs': ['painting', 'real', 'clipart', 'infograph'],
        'ood_envs': ['sketch', 'quickdraw']
    },
    'FMoW': {
        'id_envs': [0, 1, 2, 3],
        'ood_envs': [4]
    },
    'COCOShift_balanced': {
        'id_envs': ['forest', 'mountain', 'field', 'rock', 'farm'],
        'ood_envs': ['lake', 'seaside', 'garden', 'sport_field']
    },
    'COCOShift75': {
        'id_envs': ['forest', 'mountain', 'field', 'rock', 'farm'],
        'ood_envs': ['lake', 'seaside', 'garden', 'sport_field']
    },
    'COCOShift90': {
        'id_envs': ['forest', 'mountain', 'field', 'rock', 'farm'],
        'ood_envs': ['lake', 'seaside', 'garden', 'sport_field']
    },
    'COCOShift95': {
        'id_envs': ['forest', 'mountain', 'field', 'rock', 'farm'],
        'ood_envs': ['lake', 'seaside', 'garden', 'sport_field']
    }
}

# normal class tags per dataets
datasets_norm_data_tags = {
    'FMoW': 0,
    'DomainNet': 0,
    'COCOShift_balanced': 'norm',
    'COCOShift75': 'norm',
    'COCOShift90': 'norm',
    'COCOShift95': 'norm'
}

# novelty class tags per dataset
datasets_anomaly_data_tags = {
    'FMoW': 1,
    'DomainNet': 1,
    'COCOShift_balanced': 'novelty0',
    'COCOShift75': 'novelty0',
    'COCOShift90': 'novelty0',
    'COCOShift95': 'novelty0'
}
