# Only use when there is no LLM data to align (i.e., run opinion_proc.py with llm_exists=False)

import pandas as pd
import matplotlib.pyplot as plt
from . import util
from .constants import data_prefix, eval_model_save_name, player_name_col, model_name, version

# Use raw data
# input_file = f"../../result/eval/human/{data_prefix}/opinion_{eval_model_save_name}.csv"
# output_file = f"../../result/eval/human/{data_prefix}/opinion_plot_{eval_model_save_name}.svg"
# simulation_df = pd.read_csv(input_file)
# simulation_df = util.preprocess_simulation_df(simulation_df, consecutive_messages=True)

# Use simulation data
input_file = f"../../result/eval/human_llm/{data_prefix}/{model_name}/opinion_human_{eval_model_save_name}_{version}.csv"
output_file = f"../../result/eval/human_llm/{data_prefix}/{model_name}/opinion_plot_human_only_{eval_model_save_name}_{version}.svg"
simulation_df = pd.read_csv(input_file)

plt.figure(figsize=(12, 6))

# Draw separators and add round labels
simulation_df, round_separators = util.get_chat_order_and_separators(simulation_df)
util.plot_round_separators(round_separators, 2.1)
n_rounds = round_separators.shape[0] + 1
colors = {}

for round in range(n_rounds + 1):
    for player_id, group in simulation_df[simulation_df["chat_round_order"] == round].groupby(player_name_col):
        if player_id not in colors:
            line, = plt.plot(group["chat_order"], group["likert_pred"], linestyle="-", marker=".", label=f"{player_id}")
            colors[player_id] = line.get_color()
        else:
            plt.plot(group["chat_order"], group["likert_pred"], linestyle="-", marker=".", color=colors[player_id])

plt.title("Human Opinion Trajectory\n")
plt.ylim(-2.1, 2.1)
plt.yticks([-2, -1, 0, 1, 2])
plt.xlabel(f"Time Step (Chat Order)")
plt.ylabel("Likert Score")
legend = plt.legend(fontsize="small", loc="lower left")
legend.get_frame().set_alpha(0)
plt.savefig(output_file)
