import pandas as pd
from . import util
from .constants import data_prefix, eval_model_save_name, player_name_col, model_name, eval_model_name, topic, version
import openai
import os
import re


input_file = f"../../result/simulation/{data_prefix}/{model_name}/simulation-{version}.csv"
output_human_file = f"../../result/eval/human_llm/{data_prefix}/{model_name}/subtopic_list_human_{eval_model_save_name}_{version}.json"
output_llm_file = f"../../result/eval/human_llm/{data_prefix}/{model_name}/subtopic_list_llm_{eval_model_save_name}_{version}.json"
simulation_df = pd.read_csv(input_file)
simulation_df = util.preprocess_simulation_df(simulation_df, consecutive_messages=True)


def openai_1message(prompt: str, client, model_name: str):
    messages = [
        {"role": "user", "content": prompt},
    ]
    completion = client.chat.completions.create(
        model=model_name,
        messages=messages,
    )
    prediction = completion.choices[0].message.content.replace('"', '').strip()
    return prediction


for mode in ["human", "llm"]:
    conversation = []
    event_type_to_prefix = {
        "Initial Opinion": "[Initial Opinion]",
        "message_sent": "[Message]",
        "tweet": "[Tweet]",
        "Post Opinion": "[Post Opinion]",
    }
    for _, row in simulation_df.iterrows():
        conversation.append(f"{event_type_to_prefix[row['event_type']]} {row[player_name_col]}: {row['text'] if mode == 'human' else row['llm_text']}")

    conversation = "\n".join(conversation)
    prompt_template = f'Here is a conversation in the format "[event type] player: message" every line. The super topic of the conversation is pre-defined as "{{TOPIC}}". {{CONVERSATION}}\n\nInside the super topic "{{TOPIC}}", what are the subtopics discussed in the conversation? List each of them in plain text without bullet points on a separate line.\nYour predicted subtopics:\n'

    if "openai-api/" in eval_model_name:  # openai-api/gpt-4o-mini-2024-07-18
        if not os.getenv("OPENAI_API_KEY"):
            with open("openai-key.txt", "r") as f:
                os.environ["OPENAI_API_KEY"] = f.read().strip()
        client = openai.OpenAI()
        result = openai_1message(prompt_template.replace("{CONVERSATION}", conversation).replace("{TOPIC}", topic), client, eval_model_save_name)
        result = result.split("\n")
        result = [r.strip() for r in result]
    else:
        raise NotImplementedError("Not supported with memory")

    util.save_json(result, output_human_file if mode == "human" else output_llm_file)
