import os
from pathlib import Path

model_mapping = {
    'gpt-4o-mini-2024-07-18': 'gpt-4o-mini-2024-07-18',
    'ft:gpt-4o-mini-2024-07-18:camer::BOqtcdMB': 'ft:gpt-4o-mini-2024-07-18:camer:topic-split-all:BOqtcdMB',
    'ft:gpt-4o-mini-2024-07-18:camer::BOvZjzvU': 'ft:gpt-4o-mini-2024-07-18:camer:group-split-all:BOvZjzvU',
    'ft:gpt-4o-mini-2024-07-18:camer:round-split-valid:BRTJQLtG': 'ft:gpt-4o-mini-2024-07-18:camer:round-split-valid:BRTJQLtG',
    'ft:gpt-4o-mini-2024-07-18:camer::BOvS862Y': 'ft:gpt-4o-mini-2024-07-18:camer:round-split-all:BOvS862Y',
    'Llama-3.1-8B-Instruct': 'Llama-3.1-8B-Instruct',
    'llama_3.1_8b_QLoRA_May2': 'ft:Llama-3.1-8B-Instruct:round-split-valid-5epochs',
    'llama_3.1_8b_QLoRA_left': 'ft:Llama-3.1-8B-Instruct:round-split-valid-1epoch',
}

def rename_directories():
    # Get the root directory
    root_dir = Path('./result/eval/human_llm')
    
    # Keep track of renamed directories
    renamed = []
    
    # Walk through all directories
    for dirpath, dirnames, filenames in os.walk(root_dir, topdown=False):
        for dirname in dirnames:
            current_path = Path(dirpath) / dirname
            
            # Check if the directory name matches any key in the mapping
            for old_name, new_name in model_mapping.items():
                if dirname == old_name:
                    new_path = Path(dirpath) / new_name
                    try:
                        current_path.rename(new_path)
                        renamed.append((str(current_path), str(new_path)))
                        print(f"Renamed: {current_path} -> {new_path}")
                    except Exception as e:
                        print(f"Error renaming {current_path}: {e}")
                    break
    
    if not renamed:
        print("No directories found that match the model names.")
    else:
        print("\nSummary of renamed directories:")
        for old, new in renamed:
            print(f"- {old} -> {new}")

if __name__ == "__main__":
    print("Starting directory renaming process...")
    rename_directories()
    print("Finished directory renaming process.")