import os
import re
import subprocess

input_dir = os.path.join("../../data", "raw_data")
filename_pattern = r"202412(06|11)_.*\.csv"

list_files = [f for f in os.listdir(input_dir) if re.match(filename_pattern, f) is not None and os.path.isfile(os.path.join(input_dir, f))]
data_prefixes = [f[:-4] for f in list_files]

def run_python(script_name, *args):
    ret = subprocess.call(["python", script_name, *args])
    if ret != 0:
        raise Exception(f"Error running {script_name}")

for data_prefix in data_prefixes:
    print(f"DP: {data_prefix}")
    run_python("preprocessing.py", data_prefix)

print("Completed preprocessing pipeline")
