import logging
import re


class HFPipelineSuppressWarnings(logging.Filter):
    def filter1(self, message):
        pattern = r"The model 'OptimizedModule' is not supported for .*\. Supported models are .*\."
        return not re.search(pattern, message)
    
    def filter2(self, message):
        return not message == "You seem to be using the pipelines sequentially on GPU. In order to maximize efficiency please use a dataset"
    
    def filter3(self, message):
        pattern = r"Device set to use .*"
        return not re.search(pattern, message)
    
    def filter(self, record):
        message = record.getMessage()
        return self.filter1(message) and self.filter2(message) and self.filter3(message)


logger = logging.getLogger("transformers.pipelines.base")
logger.addFilter(HFPipelineSuppressWarnings())
