#!/usr/bin/env bash
# This script is for XXXX-40 running simulate_conversation.py

echo "[mini-twitter-llm-agent-modeling]"
echo "simulate_conversation.sh"
echo "Job $1 running on `hostname` with GPU $CUDA_VISIBLE_DEVICES"
echo "HuggingFace model: $2"

cd $_CONDOR_SCRATCH_DIR/src

export HOME="$_CONDOR_SCRATCH_DIR"
export TMPDIR="$_CONDOR_SCRATCH_DIR/tmp"
export USER=$(sed -n "1p" < ../../secrets.txt)  # fill in your username
export STAGING_DIR="/staging/$USER"

export NUMBA_CACHE_DIR="$_CONDOR_SCRATCH_DIR/tmp/numba"
export HF_HOME="$_CONDOR_SCRATCH_DIR/tmp/huggingface"
export HF_HUB_CACHE="$STAGING_DIR/huggingface/models"
export HF_DATASETS_CACHE="$_CONDOR_SCRATCH_DIR/tmp/huggingface/datasets"
export HUGGINGFACEHUB_API_TOKEN=$(sed -n "2p" < ../../secrets.txt)  # fill in your token

huggingface-cli login --token $HUGGINGFACEHUB_API_TOKEN
python3 simulate_conversation.py -a huggingface -m $2

mkdir -p ../../latest_run
mv ../../logs ../../result ../../latest_run/
