library(cocor)

# ----------
# LLM's Tweet stance change correlation vs Human's Tweet stance change correlation
# ----------
r_delta_tweet_human_llm = 0.45  # correlation between human change in tweet stance and LLM change in tweet stance
# correlation between change in tweet stance and tweet stance at time 1
r_delta_tweet_tweet_1_llm = -0.53  
r_delta_tweet_tweet_1_human = -0.42 
# correlation between change in tweet stance and the difference from partner's tweet stance at time 1
r_delta_tweet_tweet_partner_llm = 0.50
r_delta_tweet_tweet_partner_human = 0.38
# correlation between change in tweet stance and the absolute difference from partner's tweet stance at time 1
r_delta_tweet_tweet_abs_partner_llm = -0.09
r_delta_tweet_tweet_abs_partner_human = -0.08

## -------------------
## 1.  Put your numbers in one place
## -------------------
N <- 124        # paired sample size (make sure this is correct)

corr_sets <- list(
  tweet1 = list(              # Δtweet  ~  tweet at t1
    r_XA = r_delta_tweet_tweet_1_human,   # human   correlation
    r_XB = r_delta_tweet_tweet_1_llm,     # LLM     correlation
    r_AB = r_delta_tweet_human_llm        # human-Δ  vs  LLM-Δ
  ),
  partner = list(            # Δtweet  ~  partner’s tweet at t1
    r_XA = r_delta_tweet_tweet_partner_human,
    r_XB = r_delta_tweet_tweet_partner_llm,
    r_AB = r_delta_tweet_human_llm
  ),
  abs_partner = list(        # Δtweet  ~  |partner diff| at t1
    r_XA = r_delta_tweet_tweet_abs_partner_human,
    r_XB = r_delta_tweet_tweet_abs_partner_llm,
    r_AB = r_delta_tweet_human_llm
  )
)

## -------------------
## 2.  Wrapper that runs Steiger’s test
## -------------------
run_steiger <- function(corr, n){
  cocor.dep.groups.overlap(
    r.jk = corr$r_XA,   # X with A  (human)
    r.jh = corr$r_XB,   # X with B  (LLM)
    r.kh = corr$r_AB,   # A with B
    n     = n,
    alternative = "two.sided",
    test  = "steiger1980")
}

## -------------------
## 3.  Apply to every set
## -------------------
results <- lapply(corr_sets, run_steiger, n = N)

## Quick peek at p-values
sapply(results, function(x) x@steiger1980$p.value)
#          tweet1        partner    abs_partner 
#  [1] 0.0123 ...  etc.

## Full details for any test
summary(results$tweet1)   # or results[[1]]
