# CLIQ: Contrastive Learning with XAI-guided Interpretation and Model Quantization for EEG-based Emotion Recognition

## Installation

### Prerequisites
- Python 3.7+
- PyTorch 1.8+
- CUDA (for GPU acceleration)
- Other dependencies listed in `requirements.txt`

### Quick Setup
```bash
cd CLIQ
pip install -r requirements.txt
mkdir model_weights
mkdir outputs
```

## Usage

### Basic Pipeline Execution
```python
from data.general.metadata import general_metadata, datasets_metadata
from utils.run_pipeline import run_pipeline

num_exp = "experiment_seed_de"
# Select dataset
dataset_selection = "seed_de"
dataset_metadata = datasets_metadata[dataset_selection]

# Run pipeline
run_pipeline(num_exp,
            dataset_selection,
            general_metadata,
            dataset_metadata, 
            emb_dim=128,
            model_dim=None,
            channels_cut=None,
            in_features=None,
            seed=21,
            pretraining_epochs = 2, pretraining_wait_epochs = 25, 
            finetuning_epochs = 2, finetuning_wait_epochs = 25, 
            sensitivity_early_stop = 1.00001, sensitivity_save_weights = 1.00001,
            save_weights_path = "model_weights/",
            need_lr_scheduler=False,
            need_encoder_freezing=False
)
```

### Jupyter Notebook Tutorial
A step-by-step tutorial is available in `tutorials/run_pipeline.ipynb` demonstrating:
- Data loading and preprocessing
- Model configuration
- Training process on 2 tasks (pre-text and downstream)
- Evaluation and visualization
- Model quantization

## Project Structure

```
CLIQ/
├── src/                         # Main source code
│   ├── data/                    # Data loading and processing
│   ├── models/                  # Model architectures
│   └── utils/                   # Utility functions
├── tutorials/                   # Tutorial notebooks
│   ├── run_pipeline.ipynb       # Step-by-step running example
│   └── data_analysis.ipynb      # Step-by-step data analysis
├── model_weights/               # Directory for saved models
├── outputs/                     # Directory for output visualizations
├── requirements.txt             # Python dependencies
├── LICENSE                      # License
└── README.md                    # This file
```

## Project Overview

Emotion recognition is a promising direction in various fields. Various sources can be used for emotion recognition, and although the external manifestations of emotions may be hidden, physiological signs such as electroencephalogram (EEG) remain unchanged. 

One promising approach that can cope with complex dependencies in EEG signals and a small percentage of labeled data is self-supervised learning (SSL). 

Here we propose an easy-to-understand and implement approach based on a convolutional encoder using SSL.

<p align="center">
  <img height="270" src="/static/pipeline.png">
</p>

For the experiments, we used two datasets: SEED and DEAP. 

We used the following methods for feature extraction:
  - baseline correction;
  - spatial transformation (3D);
  - power spectral density (PSD);
  - differential entropy (DE);
  - differential asymmetry (DASM);
  - rational asymmetry (RASM);
  - differential caudality (DCAU).

During data analysis, we found that the largest inter-emotional differences for the 3 emotions in the SEED dataset are observed in channels T7 and T8.

<p align="center">
  <img height="270" src="/static/eda.png">
</p>

The contrastive loss function is a binary cross-entropy based on cosine similarity with a temperature coefficient and weighting parameters for positive, hard and soft negative pairs.

In the proposed approach, each batch element must contain at least two different elements in this batch, forming positive and negative pairs with it, respectively.

A convolutional encoder with a subsequent classifier was used as a model. This architecture was chosen due to the simplicity of the architecture both in its understanding and in size, as well as relatively high performance.

<p align="center">
  <img height="270" src="/static/model.png">
</p>

Since the model was trained using SSL we applied post-training static quantization with a symmetric linear mapping of the absolute maximum to reduce its size.

Moreover, we iteratively applied the DeepLIFT XAI method to identify and remove EEG channels and frequency bands with minimal or irrelevant contributions, improving training and inference efficiency and reducing computational load and model complexity without compromising predictive performance.


## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.
