(TeX-add-style-hook
 "falk_456-supp"
 (lambda ()
   (TeX-add-to-alist 'LaTeX-provided-class-options
                     '(("uai2022" "accepted")))
   (TeX-add-to-alist 'LaTeX-provided-package-options
                     '(("babel" "american") ("natbib" "sort&compress" "numbers") ("inputenc" "utf8") ("fontenc" "T1") ("appendix" "toc" "page") ("diffcoeff" "ISO")))
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "href")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperref")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperimage")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperbaseurl")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "nolinkurl")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "url")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "path")
   (add-to-list 'LaTeX-verbatim-macros-with-delims-local "path")
   (TeX-run-style-hooks
    "latex2e"
    "uai2022"
    "uai202210"
    "babel"
    "hyperref"
    "natbib"
    "mathtools"
    "siunitx"
    "booktabs"
    "tikz"
    "makecell"
    "inputenc"
    "fontenc"
    "url"
    "amsfonts"
    "nicefrac"
    "microtype"
    "xcolor"
    "graphicx"
    "graphbox"
    "subfig"
    "amsmath"
    "amssymb"
    "mathrsfs"
    "bm"
    "algorithm"
    "algorithmic"
    "amsthm"
    "appendix"
    "enumitem"
    "diffcoeff"
    "thmtools"
    "etoolbox"
    "placeins"
    "cleveref")
   (TeX-add-symbols
    '("SetSymbol" ["argument"] 0)
    '("swap" ["argument"] 2)
    '("kernelmatr" 1)
    '("rkhs" 1)
    '("kernel" 1)
    '("matr" 1)
    '("mc" 1)
    '("red" 1)
    '("mass" 1)
    '("ar" 1)
    '("rosanna" 1)
    '("ros" 1)
    '("rf" 1)
    '("CC" 1)
    '("JF" 1)
    '("MP" 1)
    "indic"
    "pushforward"
    "R"
    "inputspace"
    "outputspace"
    "dataspace"
    "hypothesisspace"
    "algorithmspace"
    "latentspace"
    "Lip"
    "distas"
    "domain"
    "E"
    "metadistribution"
    "taskdistribution"
    "taskdataset"
    "tasktrain"
    "taskval"
    "ntr"
    "nva"
    "nts"
    "metatrain"
    "metaval"
    "metatest"
    "inneralgorithm"
    "metaalgorithm"
    "risk"
    "emprisk"
    "innerloss"
    "metaloss"
    "randmetaloss"
    "metarisk"
    "empmetarisk"
    "diam"
    "Tr"
    "tran"
    "idmat"
    "diag"
    "given"
    "argmin")
   (LaTeX-add-labels
    "app:glossary"
    "app:closed-form-pf-gaussian"
    "eq:real-cf-kernel-form"
    "lem:gauss-cf"
    "app:bound"
    "eq:2"
    "eq:3"
    "eq:4"
    "eq:emprical-risk-with-S"
    "eq:5"
    "sec:kernel-family"
    "eq:1"
    "eq:real-translation-invariant-kernel"
    "eq:41"
    "eq:42"
    "eq:7"
    "lem:maurer09-psd-operator-facts"
    "eq:9"
    "eq:10"
    "prop:bounding-task-loss-terms"
    "eq:16"
    "eq:17"
    "thm:rad-gauss-complexity-results"
    "eq:15"
    "eq:19"
    "cor:gauss-complexity-lipschitz-composition"
    "eq:population-train-error"
    "eq:14"
    "eq:upper-bound-of-estimation-error"
    "eq:upper-bound-of-estimation-error-full"
    "eq:upper-bound-of-estimation-error-full-first-eq"
    "eq:upper-bound-of-estimation-error-full-inner-term"
    "eq:20"
    "eq:21"
    "eq:22"
    "eq:bound-on-A/E-full"
    "eq:12"
    "eq:mtl-rademacher"
    "eq:m1"
    "thm:tropp19-rff"
    "eq:sampling-expectation-bound"
    "lem:g-bound"
    "eq:8"
    "eq:11"
    "eq:24"
    "eq:25"
    "eq:26"
    "lem:G-bound"
    "eq:27"
    "eq:28"
    "eq:29"
    "eq:rff-error"
    "eq:rff-semi-bound"
    "eq:31"
    "eq:final-1"
    "eq:final-2"
    "eq:final-3"
    "eq:final-4"
    "eq:final-5"
    "eq:final-6"
    "app:datasets"
    "app:air-quality-dataset"
    "app:gas-sensor-dataset"
    "app:exp-results"
    "app:exp-hardware"
    "app:exp-algorithms"
    "app:synthetic-experiment"
    "sec:learning-curves"
    "fig:beijing-air-quality-learning-curves"
    "fig:gas-sensor-learning-curves"
    "sec:cross-val"
    "tab:valid-rmse-for-r2d2-ikml-anp"
    "sec:more-shots"
    "tab:more-shots-air-quality"
    "tab:more-shots-gas-sensor"
    "fig:synthetic-3-layer-MLP"
    "fig:r2d2-vs-ikml-mlp-air-quality-num-hidden"
    "fig:r2d2-vs-ikml-mlp-air-quality-num-layers"
    "fig:r2d2-vs-ikml-mlp-gas-sensor-num-hidden"
    "fig:r2d2-vs-ikml-mlp-gas-sensor-num-layers"
    "app:computational-complexity"
    "tab:timings")
   (LaTeX-add-bibliographies
    "falk_456/latex/bibliography.bib")
   (LaTeX-add-mathtools-DeclarePairedDelimiters
    '("abs" "")
    '("scal" "2")
    '("norm" "")
    '("Set" "1"))
   (LaTeX-add-thmtools-declaretheorems
    "theorem"
    "lemma"
    "fact"
    "proposition"
    "remark"
    "corollary"
    "definition"
    "conjecture"
    "axiom"
    "assumption"
    "example"))
 :latex)

