(TeX-add-style-hook
 "falk_456"
 (lambda ()
   (TeX-add-to-alist 'LaTeX-provided-class-options
                     '(("uai2022" "accepted")))
   (TeX-add-to-alist 'LaTeX-provided-package-options
                     '(("babel" "american") ("natbib" "sort&compress" "numbers") ("inputenc" "utf8") ("fontenc" "T1") ("appendix" "toc" "page") ("diffcoeff" "ISO")))
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "href")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperref")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperimage")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperbaseurl")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "nolinkurl")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "url")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "path")
   (add-to-list 'LaTeX-verbatim-macros-with-delims-local "path")
   (TeX-run-style-hooks
    "latex2e"
    "uai2022"
    "uai202210"
    "babel"
    "hyperref"
    "natbib"
    "mathtools"
    "siunitx"
    "booktabs"
    "tikz"
    "makecell"
    "inputenc"
    "fontenc"
    "url"
    "amsfonts"
    "nicefrac"
    "microtype"
    "xcolor"
    "graphicx"
    "graphbox"
    "subfig"
    "amsmath"
    "amssymb"
    "mathrsfs"
    "bm"
    "algorithm"
    "algorithmic"
    "amsthm"
    "appendix"
    "enumitem"
    "diffcoeff"
    "thmtools"
    "etoolbox"
    "placeins"
    "cleveref")
   (TeX-add-symbols
    '("SetSymbol" ["argument"] 0)
    '("swap" ["argument"] 2)
    '("kernelmatr" 1)
    '("rkhs" 1)
    '("kernel" 1)
    '("matr" 1)
    '("mc" 1)
    '("red" 1)
    '("mass" 1)
    '("ar" 1)
    '("rosanna" 1)
    '("ros" 1)
    '("rf" 1)
    '("CC" 1)
    '("JF" 1)
    '("MP" 1)
    "indic"
    "pushforward"
    "R"
    "inputspace"
    "outputspace"
    "dataspace"
    "hypothesisspace"
    "algorithmspace"
    "latentspace"
    "Lip"
    "distas"
    "domain"
    "E"
    "metadistribution"
    "taskdistribution"
    "taskdataset"
    "tasktrain"
    "taskval"
    "ntr"
    "nva"
    "nts"
    "metatrain"
    "metaval"
    "metatest"
    "inneralgorithm"
    "metaalgorithm"
    "risk"
    "emprisk"
    "innerloss"
    "metaloss"
    "randmetaloss"
    "metarisk"
    "empmetarisk"
    "diam"
    "Tr"
    "tran"
    "idmat"
    "diag"
    "given"
    "argmin")
   (LaTeX-add-labels
    "sec:metaR"
    "eq:expected_risk"
    "eq:meta-loss1"
    "eq:meta-loss"
    "eq:meta-risk"
    "sec:implicit-kernel-meta-learning"
    "sec:kernels"
    "eq:krr"
    "eq:krr-solution"
    "eq:random-feature-kernel"
    "eq:bochners-theorem"
    "eq:ideal-meta-krr"
    "ex:affine-pushfowrward"
    "eq:affine-kernel"
    "sec:method"
    "eq:random-features-kernel"
    "eq:stochastic-meta-loss"
    "eq:stochastic-meta-risk"
    "alg:IKML-online-optimisation"
    "sec:genbound"
    "thm:main"
    "1rr"
    "2rr"
    "3rr"
    "sec:experiments"
    "sec:synthetic"
    "fig:bochner-synthetic-regression"
    "par:training-procedure"
    "par:air-quality"
    "par:gas-sensor"
    "tab:beijing-air-quality-and-gas-sensor-experiment"
    "tab:additional-metrics"
    "sec:conclusion")
   (LaTeX-add-bibliographies
    "./bibliography.bib")
   (LaTeX-add-mathtools-DeclarePairedDelimiters
    '("abs" "")
    '("scal" "2")
    '("norm" "")
    '("Set" "1"))
   (LaTeX-add-thmtools-declaretheorems
    "theorem"
    "lemma"
    "fact"
    "proposition"
    "remark"
    "corollary"
    "definition"
    "conjecture"
    "axiom"
    "assumption"
    "example"))
 :latex)

