import logging

logger = logging.getLogger(__name__)


class SubCommand(object):
    def __init__(self):
        pass

    @classmethod
    def add_parser(cls, super_parser):
        pass

    @staticmethod
    def add_arguments(parser):
        pass


def setup_hf_logging_and_seed(model_args, data_args, training_args):
    from transformers import set_seed
    logging.basicConfig(
        format="%(asctime)s - %(levelname)s - %(name)s -   %(message)s",
        datefmt="%m/%d/%Y %H:%M:%S",
        level=logging.INFO if training_args.local_rank in [-1, 0] else logging.WARN,
    )
    logger.warning(
        "Process rank: %s, device: %s, n_gpu: %s, distributed training: %s, 16-bits training: %s",
        training_args.local_rank,
        training_args.device,
        training_args.n_gpu,
        bool(training_args.local_rank != -1),
        training_args.fp16,
    )
    logger.info("Model arguments %s", model_args)
    logger.info("Data arguments %s", data_args)
    logger.info("Training/evaluation argument %s", training_args)
    set_seed(training_args.seed)


def setup_logging_config(level=logging.INFO, out_file=None, prefix=None):
    """Configure logging module.

    Args:
      level (logging level, optional): logging level, default logging.INFO
      out_file (str, optinal): output file path to write log, default None to disable
      prefix (str, optional): prefix to add to logs
    """
    handlers = [logging.StreamHandler()]
    if out_file:
        handlers += [logging.FileHandler(out_file)]

    formatter = "%(asctime)s - %(levelname)s - %(name)s - %(message)s"
    if prefix:
        formatter = prefix + formatter

    logging.basicConfig(
        format=formatter,
        datefmt="%m/%d/%Y %H:%M:%S",
        level=level,
        handlers=handlers,
    )
