from locale import normalize
import numpy as np
import cv2
import torch
from PIL import Image
import pickle

def read(path, frame=500):
    frames = []
    cap = cv2.VideoCapture(path)
    if frame is None:
        ret = True
        while ret:
            ret, img = cap.read()  # img is (H, W, C)
            if ret:
                frames.append(img)
    else:
        for i in range(frame):
            ret, img = cap.read()  # img is (H, W, C)
            if ret:
                frames.append(img)
    video = np.stack(frames, axis=0)  # dimensions (T, H, W)
    return video

def data(path, args):
    N, N_train, N_test, raw, dataType = args.N, args.N_train, args.N_test, args.raw, args.dataType
    nmlz = args.normalize
    fname = path+'video/'+str(dataType)+'.mp4'
    rawpath = path + 'trainset/' + str(dataType) + str(N) + '_' + str(N_train) + '_' + str(N_test) +'.dat'
    if raw:
        print("Start storing "+ str.upper(dataType) + "...")
        try:
            A = read(fname, N)
            A = torch.Tensor(A.reshape(A.shape[0], A.shape[1]*3, -1))
            index = np.random.choice(N, size = N_train + N_test, replace = False)
            A_train = A[index[:N_train], :, :]
            A_test = A[index[N_train:], :, :]
            if nmlz:
                for i in range(N_train):
                    A_temp = A_train[i, :, :]
                    s = torch.linalg.svdvals(A_temp)
                    A_train[i, :, :] /= s[0]
                for i in range(N_test):
                    A_temp = A_test[i, :, :]
                    s = torch.linalg.svdvals(A_temp)
                    A_test[:, :, :] /= s[0]
            with open(rawpath, 'wb') as f:
                pickle.dump([A_train, A_test], f)
                print("Storing finished.")
        except IOError:
            print("Error: path not exist!")
        except IndexError:
            print("Error: index out of range!")
    else:
        with open(rawpath, 'rb') as f:
            A_train, A_test = pickle.load(f)
    return A_train, A_test
    
