import imageio
import os
import numpy as np
import sys

import d4rl
import gym

class VideoRecorder(object):
    def __init__(self, root_dir, height=256, width=256, camera_id=0, fps=30):
        if root_dir:
            try:
                os.mkdir(os.path.join(root_dir, 'video'))
            except:
                print("failed to make video folder")
            self.save_dir = os.path.join(root_dir, 'video')
        else:
            self.save_dir = None
        self.height = height
        self.width = width
        self.camera_id = camera_id
        self.fps = fps
        self.frames = []

    def init(self, enabled=True):
        self.frames = []
        self.enabled = self.save_dir is not None and enabled

    def record(self, env):
        if self.enabled:
            frame = env.render(mode='rgb_array',
                               height=self.height,
                               width=self.width)#,
                               #camera_id=self.camera_id)
            self.frames.append(frame)

    def save(self, file_name):
        if self.enabled:
            path = os.path.join(self.save_dir, file_name)
            imageio.mimsave(path, self.frames, fps=self.fps)
            #print("saving at ...", path)
