# Target Driven Image Classification
## Introduction
This is the official implementation for the ICLR [submmission](https://openreview.net/forum?id=UUAoXcJ0HVD).
This project relies on `pytorch 1.2`. Most of the datasets are provided by torchvision library so it should be easy to replicate majority of the results. For datasets not provided by torchvision, the links are provided at the end of this document.

## Installation

1. Firstly, make sure you have nvidia-docker installed on your system. Install [NVIDIA Docker](https://github.com/NVIDIA/nvidia-docker)
2. Clone/Copy the repository at `$DIR` on your local system


### Running the docker container

1. Navigate to `$DIR/`
2. `nvidia-docker build --rm --tag inn:latest .`
3. `nvidia-docker run --ipc=host -v $DIR:/inn --rm --name inn -it inn:latest`
4. `cd /inn`
5. `pip install -r requirements.txt`

## Replicating the experiments

##### The config
Refer to `$DIR/config/sample.yml` to understand the structure of a config file.
By default, the configs are set to run the _stl10_ training with `N=9`.

##### Training the models

1. `main_bt.py` is for B-T mode of training
2. `main_bml.py` is for B-ML mode of training
3. `main_inn.py` is for training the INN 

To train an INN model, run:
`CUDA_VISIBLE_DEVICES=0 python main_inn.py --config configs/sample.yml`

By default, this will begin the training on STL-10.  It will create a checkpoint folder to save the model and also save the supplied config in `json` format at the checkpoint location.
_A pre-trained model on STL-10 is provided in `checkpoints/stl10/`_
 

##### Grad-Cam visualisation
`CUDA_VISIBLE_DEVICES=0 python eval.py -t cam -b  checkpoints/stl10/n_9/setting.json`

##### Inference
`CUDA_VISIBLE_DEVICES=0 python eval.py -t eval -b  checkpoints/stl10/n_9/setting.json`

##### Z vs Psi
`CUDA_VISIBLE_DEVICES=0 python eval.py -t zee -b  checkpoints/stl10/n_9/setting.json`

##### OOD experiment
`CUDA_VISIBLE_DEVICES=0 python eval.py -t ood -b  checkpoints/stl10/n_9/setting.json`



### Datasets not provided by torchvision
##### CUB-200 | CUB-20
CUB-200-2011 is available [here](http://www.vision.caltech.edu/visipedia/CUB-200-2011.html). Download and unzip the content to `$DIR/data/`. 
To create `CUB-20`, first initialize an empty directory `$DIR/data/cub20`. 
Copy the contents from `cub20_setup`:`cp cub20_setup/* data/cub20/`
Copy from `CUB-200` the image folders with the matching names in `cub20_setup/classes.txt` to `data/cub20/images`.

##### Oxford-IIIT Pets
Download it from [here](https://www.robots.ox.ac.uk/~vgg/data/pets/)
Unzip the images and gt inside `$DIR/pets/`

##### BMW-10
Download it from [here](https://ai.stanford.edu/~jkrause/cars/car_dataset.html)
Unzip the images to a folder structure `$DIR/data/bmw10`


##### Tiny ImageNet
Obtain the dataset from [here](https://tiny-imagenet.herokuapp.com/)
Unzip the files inside `$DIR/data`
Make sure the root path to the tiny imgnet dataset is like `$DIR/data/tiny-64`

##### LSUN
Download instructions are provided at its official [github](https://github.com/fyu/lsun) repository.
