# Llamole Code

Please initialize an environment first:

```bash
conda create --name llamole python=3.11 -y
conda activate llamole
```

The environment requirements are specified in `require_install.sh`. You can run this script to install all necessary packages.

Pretrained models should be placed in the following directories:

- `saves/graph_decoder`
- `saves/graph_encoder`
- `saves/graph_predictor`

Configuration files are located at:

- `config/train/{model}_lora.yaml`
- `config/generate/{model}_{task}.yaml`

These configuration files contain the relative paths to the pretrained graph models, fine-tuning adapters, and graph LLM connector modules (e.g., the linear layers). Please ensure they correspond to the saved models in the `saves` folder.

Examples of training and evaluation data are provided in the `data` folder. See `data/dataset_info.json` for details.

To run the code for training with pretrained graph models in the `saves` folder, use the following command:

```bash
python main.py train config/train/mistral_lora.yaml
```

To run the model for generation, use this command:

```bash
python main.py eval config/generate/qwen_material.yaml
```  