import sys
from src.train.tuner import run_train, merge_adapter
from src.eval.workflow import run_eval

if __name__ == "__main__":
    command = sys.argv.pop(1) if len(sys.argv) != 1 else 'train'
    if command == 'train':
        run_train()
    elif command == 'export':
        merge_adapter()
    elif command == 'eval':
        run_eval()
    else:
        print(f"Invalid command: {command}. Please use 'train' or 'export'.")
        sys.exit(1)