import numpy as np
import pandas as pd
import torch
from sklearn.model_selection import train_test_split
from sklearn.preprocessing import StandardScaler
from sklearn.svm import SVC
from sklearn.metrics import roc_auc_score, confusion_matrix
from scipy.special import softmax
import time

data = np.load('ADNI_NC_MCI.npy', allow_pickle=True).item()
adj = torch.from_numpy(data['adj']).float()
X = torch.from_numpy(data['timeseries']).float().transpose(1,2)
Y = torch.from_numpy(data['label']).long()
Y = Y.squeeze(1)
X_Train, X_Test, Y_Train, Y_Test = train_test_split(X, Y, test_size = 0.25, random_state = 113) # 1 11 111 112 113

classifier = SVC(kernel = 'linear', random_state = 0, probability=True)
# classifier = SVC(kernel = 'linear', random_state = 0)

sc_X = StandardScaler()
start_time = time.time()
X_train_pooled = np.mean(X_Train.numpy(), axis=1)
model = classifier.fit(X_train_pooled, Y_Train)

support_vector_count = model.support_.size
print(f"support_vector_count: {support_vector_count}")

X_test_pooled = np.mean(X_Test.numpy(), axis=1)
Y_Pred = classifier.predict(X_test_pooled)
Y_Pred = torch.tensor(Y_Pred)
Y_Prob = classifier.predict_proba(X_test_pooled)
print(f"Total time elapsed: {time.time() - start_time:.4f}s")

correct = Y_Pred.eq(Y_Test).sum().item()
print('ACC: {:.4f}'.format(correct / Y_Test.shape[0]))

auroc = roc_auc_score(Y_Test, Y_Pred)
print('AUROC: {:.4f}'.format(auroc))

conf_matrix = confusion_matrix(Y_Test, Y_Pred)
tn = conf_matrix[0, 0]
fp = conf_matrix[0, 1]
fn = conf_matrix[1, 0]
tp = conf_matrix[1, 1]

# Sensitivity, Specificity, F1
sensitivity = tp / (tp + fn)
specificity = tn / (tn + fp)
f1_score = 2 * tp / (2 * tp + fp + fn)

print('Sensitivity: {:.4f}'.format(sensitivity))
print('Specificity: {:.4f}'.format(specificity))
print('F1: {:.4f}'.format(f1_score))

