# IMPORTS
import os
import logging
import hydra
from omegaconf import DictConfig, OmegaConf
from image_runner import Runner
import wandb

@hydra.main(config_path="conf", config_name="config_image")
def main(cfg: DictConfig):
    # absolute path
    cfg.data_dir = hydra.utils.to_absolute_path(cfg.data_dir)
    # relative to hydra path
    os.makedirs(cfg.model_dir, exist_ok=True)
    os.makedirs(cfg.log_dir, exist_ok=True)

    config_dict = OmegaConf.to_container(
        cfg, resolve=True, throw_on_missing=True
    )
    wandb.init(project="", config=config_dict, mode=cfg.wandb_mode)

    logging.info(os.getcwd())
    logging.info(OmegaConf.to_yaml(cfg))

    runner = Runner(cfg)

    if cfg.mode == 'train':
        runner.train()
    elif cfg.mode == 'generate':
        runner.generate()
    else:
        raise NotImplementedError

if __name__ == "__main__":
    main()
    
