import os
import logging
import hydra
from omegaconf import DictConfig, OmegaConf
import wandb
from mol_runner import Runner


import torch.multiprocessing

torch.multiprocessing.set_sharing_strategy('file_system')

@hydra.main(config_path="conf", config_name="config_moses")
def main(cfg: DictConfig):
    # absolute path
    cfg.data_dir = hydra.utils.to_absolute_path(cfg.data_dir)
    # relative to hydra path
    os.makedirs(cfg.model_dir, exist_ok=True)
    os.makedirs(cfg.log_dir, exist_ok=True)
    logging.info(os.getcwd())
    logging.info(OmegaConf.to_yaml(cfg))

    config_dict = OmegaConf.to_container(
        cfg, resolve=True, throw_on_missing=True
    )
    wandb.init(project="", config=config_dict, mode=cfg.wandb_mode)
    # process_config(cfg)
    runner = Runner(cfg)

    if cfg.mode == 'train':
        runner.train()
    else:
        raise NotImplementedError

if __name__ == "__main__":
    main()