import os
import logging
import hydra
from omegaconf import DictConfig, OmegaConf
from text_runner import Runner

import torch.multiprocessing

torch.multiprocessing.set_sharing_strategy('file_system')

@hydra.main(config_path="config", config_name="config_text")
def main(cfg: DictConfig):
    # absolute path
    cfg.data_dir = hydra.utils.to_absolute_path(cfg.data_dir)
    # relative to hydra path
    os.makedirs(cfg.model_dir, exist_ok=True)
    os.makedirs(cfg.log_dir, exist_ok=True)
    logging.info(os.getcwd())
    logging.info(OmegaConf.to_yaml(cfg))

    process_config(cfg)
    runner = Runner(cfg)

    if cfg.mode == 'train':
        runner.train()
    elif cfg.mode == 'test':
        runner.test()
    elif cfg.mode == 'eval_test':
        runner.eval_test()
    elif cfg.mode == 'generate':
        runner.generate()
    else:
        raise NotImplementedError

if __name__ == "__main__":
    main()
    
