num_workers=36
epochs=20
csv_ending=.csv
checkpoint_ending=.pth
connector=_
residuename=NoResidue
warmupname=NoWarmup
reshufflename=NoSwapout
# # Dataset Loop
# for dataset in cifar10 svhn fashionmnist mnist
# do
#     # Baseline
#     python train.py \
#         --$dataset \
#         --epochs $epochs \
#         --gpu \
#         --num_workers $num_workers \
#         --fresh_start \
#         --metric_file_name $dataset$csv_ending

#     # F1 Loop
#     for f1_threshold in 0.80 0.85 0.90 0.95
#     do
#         # Residue Loop
#         for residue in 0.10 0.50
#         do
#             # Warmup Loop
#             for warmup_period in 0 5
#             do
#                     # Reshuffle policy
#                 for reshuffle_policy in 0 1
#                 do
#                     metric_file_name=$dataset$connector$f1_threshold$connector$residue$connector$warmup_period$connector$restriction_policy$connector$reshuffle_policy$connector$csv_ending
#                     python train.py \
#                         --$dataset \
#                         --epochs $epochs \
#                         --num_workers $num_workers \
#                         --gpu \
#                         --fresh_start \
#                         --remove_classes \
#                         --warmup_period $warmup_period \
#                         --f1_threshold $f1_threshold \
#                         --residue $residue \
#                         --removal_restriction 0 \
#                         --reset_residue $reshuffle_policy \
#                         --metric_file_name $metric_file_name
#                 done
#             done
#         done
#     done
#     mv ./logs/train.log ./logs/$dataset.log
# done


# Dataset Loop
for dataset in mnist fashionmnist svhn cifar10
do
    # Baseline method
    python train.py \
        --$dataset \
        --epochs $epochs \
        --gpu \
        --num_workers $num_workers \
        --fresh_start \
        --log_dir ./ablation_logs \
        --checkpoint_dir ./ablation_checkpoints \
        --checkpoint_file $dataset$checkpoint_ending \
        --metric_file_name $dataset$csv_ending


    # F1 Threshold Loop
    for f1_threshold in 0.85 0.95
    do
        # F1 Experiment
        checkpoint_file_name=$dataset$connector$f1_threshold$checkpoint_ending
        metric_file_name=$dataset$connector$f1_threshold$csv_ending
        python train.py \
            --$dataset \
            --epochs $epochs \
            --num_workers $num_workers \
            --gpu \
            --fresh_start \
            --remove_classes \
            --warmup_period 5 \
            --f1_threshold $f1_threshold \
            --residue 0.10 \
            --removal_restriction 0 \
            --reset_residue 1 \
            --log_dir ./ablation_logs \
            --checkpoint_dir ./ablation_checkpoints \
            --checkpoint_file $checkpoint_file_name \
            --metric_file_name $metric_file_name

        # Residue Experiment
        checkpoint_file_name=$dataset$connector$f1_threshold$residuename$checkpoint_ending
        metric_file_name=$dataset$connector$f1_threshold$residuename$csv_ending
        python train.py \
            --$dataset \
            --epochs $epochs \
            --num_workers $num_workers \
            --gpu \
            --fresh_start \
            --remove_classes \
            --warmup_period 5 \
            --f1_threshold $f1_threshold \
            --residue 0.00 \
            --removal_restriction 0 \
            --reset_residue 1 \
            --log_dir ./ablation_logs \
            --checkpoint_dir ./ablation_checkpoints \
            --checkpoint_file $checkpoint_file_name \
            --metric_file_name $metric_file_name

        # Warmup Experiment
        checkpoint_file_name=$dataset$connector$f1_threshold$warmupname$checkpoint_ending
        metric_file_name=$dataset$connector$f1_threshold$warmupname$csv_ending
        python train.py \
            --$dataset \
            --epochs $epochs \
            --num_workers $num_workers \
            --gpu \
            --fresh_start \
            --remove_classes \
            --warmup_period 0 \
            --f1_threshold $f1_threshold \
            --residue 0.10 \
            --removal_restriction 0 \
            --reset_residue 1 \
            --log_dir ./ablation_logs \
            --checkpoint_dir ./ablation_checkpoints \
            --checkpoint_file $checkpoint_file_name \
            --metric_file_name $metric_file_name

        # Residue Swapout Experiment
        checkpoint_file_name=$dataset$connector$f1_threshold$reshufflename$checkpoint_ending
        metric_file_name=$dataset$connector$f1_threshold$reshufflename$csv_ending
        python train.py \
            --$dataset \
            --epochs $epochs \
            --num_workers $num_workers \
            --gpu \
            --fresh_start \
            --remove_classes \
            --warmup_period 5 \
            --f1_threshold $f1_threshold \
            --residue 0.10 \
            --removal_restriction 0 \
            --reset_residue 0 \
            --log_dir ./ablation_logs \
            --checkpoint_dir ./ablation_checkpoints \
            --checkpoint_file $checkpoint_file_name \
            --metric_file_name $metric_file_name
    done
done

# # Specific Test
# python train.py \
#     --svhn \
#     --epochs $epochs \
#     --num_workers $num_workers \
#     --gpu \
#     --fresh_start \
#     --remove_classes \
#     --warmup_period 5 \
#     --f1_threshold 0.80 \
#     --residue 0.10 \
#     --removal_restriction 1 \
#     --reset_residue 0 \
#     --metric_file_name test.csv