import os
from sklearn.model_selection import ParameterGrid
from modules.args import get_args
from modules.experiments.das_experiments import DASExperiment
from modules.experiments.ges_experiment import GESExperiment
from modules.experiments.cam_experiment import CAMExperiment

base_folder = "/home/francescom/Research/DAS-Extension/src"

def get_exp_instance(args):
    algorithm = args.algorithm
    if algorithm=="DASExt":
        return DASExperiment(**vars(args))
    elif algorithm=="CAM":
        return CAMExperiment(**vars(args))
    elif algorithm=="GES":
        return GESExperiment(**vars(args))
    else:
        raise Exception(f"Causal discovery algorithm {algorithm} is not known!")


# Command line args
args = get_args()
args.output_path = base_folder + args.output_path

check_dir = '/'.join([folder for folder in args.output_path.split('/')[:-1]])
if not os.path.exists(check_dir):
    raise OSError(f"Output path {check_dir} does not exist!")

exp_manager = get_exp_instance(args)
params_grid = ParameterGrid(
    {
        'alpha' : [args.alpha], 
        'gamma' : [args.gamma], 
        'n_cv': [args.cv],
        'd' : [10, 20],
        's0' : ['d', '4d']
    }
)

exp_manager.run_experiment(params_grid)