import argparse

def get_args():

    # Initialize parser
    parser = argparse.ArgumentParser()

    # Data generation arguments
    parser.add_argument('--graph_type', '-gt', type=str, default='ER', help="Accepted values: ER, SF")
    parser.add_argument('--noise_type', '-nt', type=str, default='Gauss', help="Accepted values: Gauss, Laplace, Gumbel, Exp, Beta, Uniform")
    parser.add_argument('-d', type=int, default=10, help="Number of causal variables")
    parser.add_argument('-s0', type=int, default=10, help="Number of expected edges")
    parser.add_argument('-N', type=int, default=1000, help="Sample size")
    parser.add_argument('-GP', default=True, action='store_false' ,help="Generate data with gaussian preocesses")
    parser.add_argument('--nstd', type=float, default=1., help="Noise standard deviation")
    parser.add_argument('--real_res', '-r', default=False, action='store_true' ,help="Use real residuals rather than estimated")

    # Hyperparameters
    parser.add_argument('--gamma', '-g', type=float, default=0.1, help="KernelRidge gamma parameter")
    parser.add_argument('--alpha', '-a', type=float, default=0.01, help="KernelRidge alpha parameter")
    parser.add_argument('-cv', type=int, default=5, help="Number of cross validation splits")
    parser.add_argument('--eta_G', type=float, default=0.001, help="Regularization coefficient 1st order")
    parser.add_argument('--cam_cutoff', type=float, default=0.001, help="CAM pruning hyperparameter")
    parser.add_argument('-K', type=int, default=20, help="Max number of candidate parents per node (DAS pruning)")
    parser.add_argument('--pns', type=int, default=None, help="Max number of candidate parents per node (CAM pruning)")

    # Others
    parser.add_argument('--pruning', '-p', default=False, action='store_true', help="Whether to prune after topological ordering inference")
    parser.add_argument('--logs', '-l', default=False, action='store_true', help="Save logs data")
    parser.add_argument('--sid', default=False, action='store_true', help="Compute SID metric")
    parser.add_argument('--plot', default=False, action='store_true', help="Make plots rather than inference")
    parser.add_argument('--algorithm', '-alg', type=str, default="DASExt", help="Select the causal discovery algorithm to run. Accepted are {DAS, DASExt, SCORE, CAM, GES")

    # Experiments
    parser.add_argument('--output_path', '-o', type=str, default=None, help="Output path for experiments. '/logs/experiments/pred-err/\{distribution\}'")
    parser.add_argument('--num_runs', '-nr', type=int, default=10, help="Number of experimental runs")


    # Read arguments from command line
    return parser.parse_args()
