import os
import time
import numpy as np
import pandas as pd
from cdt.utils.R import launch_R_script

from modules.utils import np_to_csv, fullAdj2Order

base_folder = "/home/francescom/Research/DAS-Extension/src"

class CAM:
    def __init__(self, X, cutoff, save_path = "./"):
        self.save_path = save_path
        _, self.d = X.shape
        data_np = np.array(X.detach().cpu().numpy())
        data_csv_path = np_to_csv(data_np, save_path)

        self.arguments = dict()
        self.arguments['{PATH_DATA}'] = data_csv_path
        self.arguments['{PATH_RESULTS}'] = os.path.join(save_path, "results.csv")
        self.arguments['{CUTOFF}'] = str(cutoff)
        self.arguments['{VERBOSE}'] = "FALSE"

    def retrieve_results(self):
        A = pd.read_csv(self.arguments['{PATH_RESULTS}']).values
        return A

    def clean(self, clean_dag=False):
        os.remove(self.arguments['{PATH_RESULTS}'])
        os.remove(self.arguments['{PATH_DATA}'])
        if clean_dag:
            os.remove(self.arguments['{PATH_DAG}'])

    def order(self):
        dagFull = launch_R_script(f"{base_folder}/../R_code/order.R", self.arguments, output_function=self.retrieve_results)
        top_order = fullAdj2Order(dagFull)
        return top_order, dagFull

    def pruning(self, A):
        dag_csv_path = np_to_csv(A, self.save_path) 
        self.arguments['{PATH_DAG}'] = dag_csv_path
        dag = launch_R_script(f"{base_folder}/../R_code/pruning.R", self.arguments, output_function=self.retrieve_results)
        return dag

    def run(self, pruning=False):
        start = time.time()
        order, dagFull = self.order()
        if pruning:
            dag = self.pruning(dagFull)
        else:
            dag = np.zeros((self.d, self.d))
        self.clean(clean_dag=pruning)
        return dag, order, time.time() - start
