from modules.experiments.experiment import Experiment


class GESExperiment(Experiment):
    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    def pretty_evaluate(self, metrics, d, s0, alpha, gamma, n_cv):
        fn, fp, rev, p, r, SHD, SID, top_order_err, order_time, exe_time = metrics

        pretty = f"""

----------------------------------------------------

Noise:                              {self.noise_type}
Number of nodes:                    {d}
Number of edges:                    {s0}

----------------------------------------------------

Execution time:                     {round(exe_time, 2)}s
False negative:                     {int(fn)}
False positive:                     {int(fp)}
Reversed:                           {int(rev)}
SHD:                                {SHD}
"""

        if SID != -1:
            pretty += f"""
SID:                                {SID}
""".lstrip()

        return pretty